/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.validators;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;

public class JavaASTValidator
extends ASTVisitor {
    private static final Logger LOGGER = Logger.getLogger(JavaASTValidator.class.getName());
    private List<Diagnostic> diagnostics;
    private JavaDiagnosticsContext context;

    public void initialize(JavaDiagnosticsContext context, List<Diagnostic> diagnostics) {
        this.context = context;
        this.diagnostics = diagnostics;
    }

    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public Diagnostic addDiagnostic(String message, String source, ASTNode node, IJavaErrorCode code, DiagnosticSeverity severity) {
        return this.addDiagnostic(message, source, node.getStartPosition(), node.getLength(), code, severity);
    }

    public Diagnostic addDiagnostic(String message, String source, int offset, int length, IJavaErrorCode code, DiagnosticSeverity severity) {
        try {
            String fileUri = this.context.getUri();
            ITypeRoot openable = this.context.getTypeRoot();
            Range range = this.context.getUtils().toRange((IOpenable)openable, offset, length);
            Diagnostic d = this.context.createDiagnostic(fileUri, message, range, source, code, severity);
            this.diagnostics.add(d);
            return d;
        }
        catch (JavaModelException e) {
            LOGGER.log(Level.SEVERE, "Error while creating diagnostic '" + message + "'.", e);
            return null;
        }
    }

    public JavaDiagnosticsContext getContext() {
        return this.context;
    }
}

