/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.lsp4mp.jdt.core.AbstractPropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;

public abstract class AbstractAnnotationTypeReferencePropertiesProvider
extends AbstractPropertiesProvider {
    private static final Logger LOGGER = Logger.getLogger(AbstractAnnotationTypeReferencePropertiesProvider.class.getName());

    @Override
    protected String[] getPatterns() {
        return this.getAnnotationNames();
    }

    protected abstract String[] getAnnotationNames();

    @Override
    protected SearchPattern createSearchPattern(String annotationName) {
        return AbstractAnnotationTypeReferencePropertiesProvider.createAnnotationTypeReferenceSearchPattern(annotationName);
    }

    @Override
    public void collectProperties(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
        block5: {
            IJavaElement javaElement = null;
            try {
                Object element = AbstractAnnotationTypeReferencePropertiesProvider.getMatchedElement(match);
                if (element instanceof IAnnotation) {
                    IAnnotation annotation = (IAnnotation)element;
                    javaElement = annotation.getParent();
                    this.processAnnotation(javaElement, context, monitor, annotation);
                } else if (element instanceof IAnnotatable && element instanceof IJavaElement) {
                    javaElement = (IJavaElement)element;
                    this.processAnnotation(javaElement, context, monitor);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block5;
                LOGGER.log(Level.SEVERE, "Cannot compute MicroProfile properties for the Java element '" + javaElement != null ? javaElement.getElementName() : match.getElement() + "'.", e);
            }
        }
    }

    private static Object getMatchedElement(SearchMatch match) {
        if (match instanceof TypeReferenceMatch) {
            IJavaElement localElement = ((TypeReferenceMatch)match).getLocalElement();
            return localElement != null ? localElement : match.getElement();
        }
        return match.getElement();
    }

    protected void processAnnotation(IJavaElement javaElement, SearchContext context, IProgressMonitor monitor) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = ((IAnnotatable)javaElement).getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            this.processAnnotation(javaElement, context, monitor, annotation);
            ++n2;
        }
    }

    private void processAnnotation(IJavaElement javaElement, SearchContext context, IProgressMonitor monitor, IAnnotation annotation) throws JavaModelException {
        String[] names;
        String[] stringArray = names = this.getAnnotationNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String annotationName = stringArray[n2];
            if (AnnotationUtils.isMatchAnnotation(annotation, annotationName)) {
                this.processAnnotation(javaElement, annotation, annotationName, context, monitor);
                break;
            }
            ++n2;
        }
    }

    protected abstract void processAnnotation(IJavaElement var1, IAnnotation var2, String var3, SearchContext var4, IProgressMonitor var5) throws JavaModelException;
}

