/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationAttributeRule;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationRule;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationRulesJavaASTValidator;
import org.eclipse.lsp4mp.jdt.internal.core.java.validators.annotations.AnnotationValidator;

public class JavaASTValidatorRegistry
extends AnnotationValidator
implements IRegistryChangeListener {
    private static final Logger LOGGER = Logger.getLogger(JavaASTValidatorRegistry.class.getName());
    private static final JavaASTValidatorRegistry INSTANCE = new JavaASTValidatorRegistry();
    private static final String EXTENSION_ID = "javaASTValidators";
    private static final String VALIDATOR_ELT = "validator";
    private static final String CLASS_ATTR = "class";
    private static final String ANNOTATION_VALIDATOR_ELT = "annotationValidator";
    private static final String ANNOTATION_ATTR = "annotation";
    private static final String SOURCE_ATTR = "source";
    private static final String ATTRIBUTE_ELT = "attribute";
    private static final String NAME_ATTR = "name";
    private static final String RANGE_ATTR = "range";
    private boolean extensionProvidersLoaded = false;
    private boolean registryListenerIntialized = false;
    private final List<IConfigurationElement> validatorsFromClass = new ArrayList<IConfigurationElement>();

    public static JavaASTValidatorRegistry getInstance() {
        return INSTANCE;
    }

    private JavaASTValidatorRegistry() {
    }

    public String getExtensionId() {
        return EXTENSION_ID;
    }

    @Override
    public String validate(String value, AnnotationAttributeRule rule) {
        this.loadExtensionJavaASTValidators();
        return super.validate(value, rule);
    }

    @Override
    public Collection<AnnotationRule> getRules() {
        this.loadExtensionJavaASTValidators();
        return super.getRules();
    }

    private synchronized void loadExtensionJavaASTValidators() {
        if (this.extensionProvidersLoaded) {
            return;
        }
        this.extensionProvidersLoaded = true;
        LOGGER.log(Level.INFO, "->- Loading ." + this.getExtensionId() + " extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.lsp4mp.jdt.core", this.getExtensionId());
        this.addExtensionJavaASTValidators(cf);
        this.addRegistryListenerIfNeeded();
        LOGGER.log(Level.INFO, "-<- Done loading ." + this.getExtensionId() + " extension point -<-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.lsp4mp.jdt.core", this.getExtensionId());
        if (deltas != null) {
            JavaASTValidatorRegistry javaASTValidatorRegistry = this;
            synchronized (javaASTValidatorRegistry) {
                IExtensionDelta[] iExtensionDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
                    if (delta.getKind() == 1) {
                        this.addExtensionJavaASTValidators(cf);
                    }
                    ++n2;
                }
            }
        }
    }

    private void addExtensionJavaASTValidators(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                if (VALIDATOR_ELT.equals(ce.getName())) {
                    this.validatorsFromClass.add(ce);
                } else if (ANNOTATION_VALIDATOR_ELT.equals(ce.getName())) {
                    String annotation = ce.getAttribute(ANNOTATION_ATTR);
                    String source = ce.getAttribute(SOURCE_ATTR);
                    AnnotationRule annotationRule = new AnnotationRule(annotation, source);
                    IConfigurationElement[] iConfigurationElementArray2 = ce.getChildren(ATTRIBUTE_ELT);
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement attributeElement = iConfigurationElementArray2[n4];
                        String name = attributeElement.getAttribute(NAME_ATTR);
                        String range = attributeElement.getAttribute(RANGE_ATTR);
                        AnnotationAttributeRule attributeRule = new AnnotationAttributeRule(name);
                        attributeRule.setRange(range);
                        annotationRule.addRule(attributeRule);
                        ++n4;
                    }
                    super.registerRule(annotationRule);
                }
                String pluginId = ce.getNamespaceIdentifier();
                LOGGER.log(Level.INFO, "  Loaded " + this.getExtensionId() + ": " + pluginId);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "  Loaded while loading " + this.getExtensionId(), t);
            }
            ++n2;
        }
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.lsp4mp.jdt.core");
        this.registryListenerIntialized = true;
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void initialize() {
    }

    public Collection<ASTVisitor> getValidators(JavaDiagnosticsContext context, IProgressMonitor monitor) {
        ArrayList<ASTVisitor> validators = new ArrayList<ASTVisitor>();
        this.addValidator(new AnnotationRulesJavaASTValidator(this.getRules()), context, monitor, validators);
        for (IConfigurationElement ce : this.validatorsFromClass) {
            try {
                JavaASTValidator validator = (JavaASTValidator)((Object)ce.createExecutableExtension(CLASS_ATTR));
                this.addValidator(validator, context, monitor, validators);
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, "  Error while creating JavaASTValidator " + ce.getAttribute(CLASS_ATTR), e);
            }
        }
        return validators;
    }

    private void addValidator(JavaASTValidator validator, JavaDiagnosticsContext context, IProgressMonitor monitor, List<ASTVisitor> validators) {
        validator.initialize(context);
        try {
            if (validator.isAdaptedForDiagnostics(context, monitor)) {
                validators.add(validator);
            }
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "  Error while adding validator JavaASTValidator " + ((Object)((Object)validator)).getClass().getName(), e);
        }
    }
}

