/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime.converter.full;

import java.lang.reflect.Method;
import org.eclipse.lsp4mp.commons.runtime.EnumConstantsProvider;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.commons.runtime.TypeProvider;
import org.eclipse.lsp4mp.commons.runtime.converter.AbstractConverterValidator;

class FullConverterValidator
extends AbstractConverterValidator<Object> {
    private Method getConverterMethod;
    private Method convertMethod;
    private boolean hasOptional;

    FullConverterValidator(Object config, Class<?> forType) {
        super(config, forType);
    }

    @Override
    protected void convert(String value) throws Exception {
        Object converterInstance;
        Object config = this.getConfig();
        Class<?> forType = this.getForType();
        if (this.hasOptional) {
            Object optional = this.getConverterMethod.invoke(config, forType);
            Method get = optional.getClass().getMethod("get", new Class[0]);
            converterInstance = get.invoke(optional, new Object[0]);
        } else {
            converterInstance = this.getConverterMethod.invoke(config, forType);
        }
        this.convertMethod.invoke(converterInstance, value);
    }

    @Override
    protected boolean initialize() throws Exception {
        Object converterInstance;
        Object optional;
        Method getConverter;
        block3: {
            Object config = this.getConfig();
            Class<?> forType = this.getForType();
            getConverter = config.getClass().getMethod("getConverter", Class.class);
            getConverter.setAccessible(true);
            optional = getConverter.invoke(config, forType);
            this.hasOptional = true;
            Method isPresent = optional.getClass().getMethod("isPresent", new Class[0]);
            if (((Boolean)isPresent.invoke(optional, new Object[0])).booleanValue()) break block3;
            return false;
        }
        try {
            Method get = optional.getClass().getMethod("get", new Class[0]);
            converterInstance = get.invoke(optional, new Object[0]);
        }
        catch (Exception exception) {
            this.hasOptional = false;
            converterInstance = optional;
        }
        Method convert = converterInstance.getClass().getMethod("convert", String.class);
        convert.setAccessible(true);
        this.getConverterMethod = getConverter;
        this.convertMethod = convert;
        return true;
    }

    @Override
    public void refreshEnumType(EnumConstantsProvider enumConstNamesProvider, TypeProvider typeProvider, ExecutionMode executionMode) {
        Class forType = this.getForType();
        if (forType != null && forType.isEnum()) {
            forType = (Class)typeProvider.findType(forType.getTypeName(), enumConstNamesProvider, executionMode);
            try {
                this.initialize();
            }
            catch (Exception exception) {}
        }
    }
}

