/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.lsp4mp.jdt.core.ArtifactResolver;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.MavenPluginActivator;

public class DependencyUtil {
    private static final String JAR_FILE_TYPE = "jar";
    private static final String POM_FILE_TYPE = "pom";

    public static File getArtifact(String groupId, String artifactId, String version, String classifier, IProgressMonitor monitor) throws FileNotFoundException, CoreException {
        org.apache.maven.artifact.Artifact pom;
        ArtifactKey key = new ArtifactKey(groupId, artifactId, version, classifier);
        File pomFile = DependencyUtil.getLocalArtifactFile(key, POM_FILE_TYPE);
        if (pomFile == null && (pom = MavenPlugin.getMaven().resolve(key.groupId(), key.artifactId(), key.version(), POM_FILE_TYPE, null, null, monitor)) == null) {
            throw new FileNotFoundException("Unable to find pom file for " + key);
        }
        File archive = DependencyUtil.getLocalArtifactFile(key, JAR_FILE_TYPE);
        if (archive == null) {
            org.apache.maven.artifact.Artifact artifact = MavenPlugin.getMaven().resolve(key.groupId(), key.artifactId(), key.version(), JAR_FILE_TYPE, key.classifier(), null, monitor);
            if (artifact == null) {
                throw new FileNotFoundException("Unable to find " + key);
            }
            archive = DependencyUtil.getLocalArtifactFile(key, JAR_FILE_TYPE);
        }
        return archive;
    }

    private static File getLocalArtifactFile(ArtifactKey a, String type) {
        IMaven maven = MavenPlugin.getMaven();
        try {
            ArtifactRepository localRepository = maven.getLocalRepository();
            String relPath = maven.getArtifactPath(localRepository, a.groupId(), a.artifactId(), a.version(), type, a.classifier());
            File file = new File(localRepository.getBasedir(), relPath).getCanonicalFile();
            if (file.canRead() && file.isFile()) {
                return file;
            }
        }
        catch (IOException | CoreException throwable) {}
        return null;
    }

    public static Set<ArtifactResolver.Artifact> getDependencies(String groupId, String artifactId, String version, IProgressMonitor monitor) throws CoreException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, null, version);
        CollectResult result = (CollectResult)MavenPlugin.getMaven().execute((arg_0, arg_1) -> DependencyUtil.lambda$0((Artifact)artifact, groupId, artifactId, version, arg_0, arg_1), monitor);
        if (result != null) {
            final HashSet<ArtifactResolver.Artifact> dependencies = new HashSet<ArtifactResolver.Artifact>();
            result.getRoot().accept(new DependencyVisitor(){

                public boolean visitLeave(DependencyNode node) {
                    Artifact dep = node.getDependency().getArtifact();
                    dependencies.add(new ArtifactResolver.Artifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getClassifier()));
                    return true;
                }

                public boolean visitEnter(DependencyNode node) {
                    return true;
                }
            });
            return dependencies;
        }
        return Collections.emptySet();
    }

    private static CollectResult collectDependencies(Artifact artifact, RepositorySystemSession repoSession) throws ArtifactDescriptorException, DependencyCollectionException, CoreException {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "runtime"));
        RepositorySystem repoSystem = MavenPluginActivator.getDefault().getRepositorySystem();
        repoSession = new DefaultRepositorySystemSession(repoSession);
        return repoSystem.collectDependencies(repoSession, collectRequest);
    }

    private static /* synthetic */ CollectResult lambda$0(Artifact artifact, String string, String string2, String string3, IMavenExecutionContext context, IProgressMonitor progress) throws CoreException {
        try {
            return DependencyUtil.collectDependencies(artifact, context.getRepositorySession());
        }
        catch (DependencyCollectionException | ArtifactDescriptorException e) {
            ArtifactKey key = new ArtifactKey(string, string2, string3, null);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4mp.jdt.core", "Error while collecting dependencies for " + key, e));
        }
    }
}

