/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.faulttolerance.java;

import java.text.MessageFormat;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.validators.JavaASTValidator;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.internal.faulttolerance.java.MicroProfileFaultToleranceErrorCode;

public class MicroProfileFaultToleranceASTValidator
extends JavaASTValidator {
    private static final String FALLBACK_ERROR_MESSAGE = "The referenced fallback method ''{0}'' does not exist.";
    private static final String ASYNCHRONOUS_ERROR_MESSAGE = "The annotated method ''{0}'' with @Asynchronous should return an object of type {1}.";
    private static final String RETRY_WARNING_MESSAGE = "The effective delay may exceed the `maxDuration` member value.";
    private final Map<TypeDeclaration, Set<String>> methodsCache = new HashMap<TypeDeclaration, Set<String>>();
    private final List<String> allowedReturnTypesForAsynchronousAnnotation = new ArrayList<String>(Arrays.asList("java.util.concurrent.Future", "java.util.concurrent.CompletionStage"));
    private static Logger LOGGER = Logger.getLogger(MicroProfileFaultToleranceASTValidator.class.getName());

    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        boolean adapted;
        IJavaProject javaProject = context.getJavaProject();
        boolean bl = adapted = JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.faulttolerance.Fallback") != null || JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.faulttolerance.Asynchronous") != null || JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.faulttolerance.Retry") != null;
        if (adapted) {
            this.addAllowedReturnTypeForAsynchronousAnnotation(javaProject, "io.smallrye.mutiny.Uni");
        }
        return adapted;
    }

    private void addAllowedReturnTypeForAsynchronousAnnotation(IJavaProject javaProject, String returnType) {
        if (JDTTypeUtils.findType(javaProject, returnType) != null) {
            this.allowedReturnTypesForAsynchronousAnnotation.add(returnType);
        }
    }

    public boolean visit(MethodDeclaration node) {
        try {
            this.validateMethod(node);
        }
        catch (JavaModelException javaModelException) {
            LOGGER.log(Level.WARNING, "An exception occurred when attempting to validate the annotation marked method");
        }
        super.visit(node);
        return true;
    }

    public boolean visit(TypeDeclaration type) {
        List modifiers = type.modifiers();
        for (Object modifier : modifiers) {
            if (!(modifier instanceof Annotation)) continue;
            Annotation annotation = (Annotation)modifier;
            if (AnnotationUtils.isMatchAnnotation(annotation, "org.eclipse.microprofile.faulttolerance.Asynchronous")) {
                try {
                    MethodDeclaration[] methods;
                    MethodDeclaration[] methodDeclarationArray = methods = type.getMethods();
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MethodDeclaration node = methodDeclarationArray[n2];
                        this.validateAsynchronousAnnotation(node, (MarkerAnnotation)modifier);
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {
                    LOGGER.log(Level.WARNING, "An exception occurred when attempting to validate the annotation");
                }
                continue;
            }
            if (!AnnotationUtils.isMatchAnnotation(annotation, "org.eclipse.microprofile.faulttolerance.Retry")) continue;
            try {
                this.validateRetryAnnotation((NormalAnnotation)modifier);
            }
            catch (JavaModelException javaModelException) {
                LOGGER.log(Level.WARNING, "An exception occurred when attempting to validate the annotation");
            }
        }
        super.visit(type);
        return true;
    }

    private void validateMethod(MethodDeclaration node) throws JavaModelException {
        List modifiers = node.modifiers();
        for (Object modifier : modifiers) {
            if (!(modifier instanceof Annotation)) continue;
            Annotation annotation = (Annotation)modifier;
            if (AnnotationUtils.isMatchAnnotation(annotation, "org.eclipse.microprofile.faulttolerance.Fallback")) {
                this.validateFallbackAnnotation(node, (NormalAnnotation)modifier);
                continue;
            }
            if (AnnotationUtils.isMatchAnnotation(annotation, "org.eclipse.microprofile.faulttolerance.Asynchronous")) {
                this.validateAsynchronousAnnotation(node, (MarkerAnnotation)modifier);
                continue;
            }
            if (!AnnotationUtils.isMatchAnnotation(annotation, "org.eclipse.microprofile.faulttolerance.Retry")) continue;
            this.validateRetryAnnotation((NormalAnnotation)modifier);
        }
    }

    private void validateFallbackAnnotation(MethodDeclaration node, NormalAnnotation annotation) throws JavaModelException {
        Expression fallbackMethodExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "fallbackMethod");
        if (fallbackMethodExpr != null) {
            String fallbackMethodName = fallbackMethodExpr.toString();
            fallbackMethodName = fallbackMethodName.substring(1, fallbackMethodName.length() - 1);
            if (!this.getExistingMethods(node).contains(fallbackMethodName)) {
                String message = MessageFormat.format(FALLBACK_ERROR_MESSAGE, fallbackMethodName);
                super.addDiagnostic(message, "microprofile-faulttolerance", (ASTNode)fallbackMethodExpr, MicroProfileFaultToleranceErrorCode.FALLBACK_METHOD_DOES_NOT_EXIST, DiagnosticSeverity.Error);
            }
        }
    }

    private void validateAsynchronousAnnotation(MethodDeclaration node, MarkerAnnotation annotation) throws JavaModelException {
        Type methodReturnType = node.getReturnType2();
        String methodReturnTypeString = methodReturnType.resolveBinding().getErasure().getQualifiedName();
        if (!this.isAllowedReturnTypeForAsynchronousAnnotation(methodReturnTypeString)) {
            String allowedTypes = this.allowedReturnTypesForAsynchronousAnnotation.stream().collect(Collectors.joining("', '", "'", "'"));
            String message = MessageFormat.format(ASYNCHRONOUS_ERROR_MESSAGE, node.getName(), allowedTypes);
            super.addDiagnostic(message, "microprofile-faulttolerance", (ASTNode)methodReturnType, MicroProfileFaultToleranceErrorCode.FAULT_TOLERANCE_DEFINITION_EXCEPTION, DiagnosticSeverity.Error);
        }
    }

    private void validateRetryAnnotation(NormalAnnotation annotation) throws JavaModelException {
        Expression delayExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "delay");
        Expression maxDurationExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "maxDuration");
        if (delayExpr != null && maxDurationExpr != null) {
            long jitterNum;
            long maxDurationNum;
            long delayNum;
            Object jitterConstant;
            Expression delayUnitExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "delayUnit");
            Expression durationUnitExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "durationUnit");
            Expression jitterExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "jitter");
            Expression jitterUnitExpr = AnnotationUtils.getAnnotationMemberValueExpression((Annotation)annotation, "jitterDelayUnit");
            Object delayConstant = delayExpr != null ? delayExpr.resolveConstantExpressionValue() : null;
            Object maxDurationConstant = maxDurationExpr != null ? maxDurationExpr.resolveConstantExpressionValue() : null;
            Object object = jitterConstant = jitterExpr != null ? jitterExpr.resolveConstantExpressionValue() : null;
            long l = delayConstant instanceof Integer ? (long)((Integer)delayConstant).intValue() : (delayNum = delayConstant instanceof Long ? (Long)delayConstant : -1L);
            long l2 = maxDurationConstant instanceof Integer ? (long)((Integer)maxDurationConstant).intValue() : (maxDurationNum = maxDurationConstant instanceof Long ? (Long)maxDurationConstant : -1L);
            long l3 = jitterConstant instanceof Integer ? (long)((Integer)jitterConstant).intValue() : (jitterNum = jitterConstant instanceof Long ? (Long)jitterConstant : 0L);
            if (delayNum != -1L && maxDurationNum != -1L) {
                double delayValue = this.findDurationUnit(delayUnitExpr, delayNum);
                double maxDurationValue = this.findDurationUnit(durationUnitExpr, maxDurationNum);
                double jitterValue = this.findDurationUnit(jitterUnitExpr, jitterNum);
                double maxDelayValue = delayValue + jitterValue;
                if (maxDelayValue >= maxDurationValue) {
                    super.addDiagnostic(RETRY_WARNING_MESSAGE, "microprofile-faulttolerance", (ASTNode)delayExpr, MicroProfileFaultToleranceErrorCode.DELAY_EXCEEDS_MAX_DURATION, DiagnosticSeverity.Warning);
                }
            }
        }
    }

    private double findDurationUnit(Expression memberUnitExpr, long memberUnitNum) {
        String memberUnit = null;
        if (memberUnitExpr != null) {
            SimpleName memberUnitName = memberUnitExpr instanceof SimpleName ? (SimpleName)memberUnitExpr : ((QualifiedName)memberUnitExpr).getName();
            memberUnit = memberUnitName.getIdentifier();
        }
        return memberUnit != null ? this.getDurationInNanos(ChronoUnit.valueOf(memberUnit), memberUnitNum) : this.getDurationInNanos(ChronoUnit.MILLIS, memberUnitNum);
    }

    public double getDurationInNanos(ChronoUnit unit, long unitValue) {
        double seconds = unit.getDuration().getSeconds();
        int nanos = unit.getDuration().getNano();
        return seconds * 1.0E9 * (double)unitValue + (double)((long)nanos * unitValue);
    }

    private boolean isAllowedReturnTypeForAsynchronousAnnotation(String returnType) {
        return this.allowedReturnTypesForAsynchronousAnnotation.contains(returnType);
    }

    private Set<String> getExistingMethods(MethodDeclaration node) {
        TypeDeclaration type = this.getOwnerType((ASTNode)node);
        if (type == null) {
            return Collections.emptySet();
        }
        return this.getExistingMethods(type);
    }

    private TypeDeclaration getOwnerType(ASTNode node) {
        while (node != null) {
            if (node instanceof TypeDeclaration) {
                return (TypeDeclaration)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private Set<String> getExistingMethods(TypeDeclaration type) {
        Set<String> methods = this.methodsCache.get(type);
        if (methods == null) {
            methods = Stream.of(type.getMethods()).map(m -> m.getName().getIdentifier()).collect(Collectors.toUnmodifiableSet());
            this.methodsCache.put(type, methods);
        }
        return methods;
    }
}

