/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.jaxrs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.jaxrs.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.jaxrs.ErrorCode;

public class ClassConstructorDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        String uri = context.getUri();
        IJavaElement[] elements = typeRoot.getChildren();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IType type;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return null;
            }
            if (element.getElementType() == 7 && (type = (IType)element).isClass()) {
                IAnnotation[] annotationList;
                boolean isRootResource = false;
                boolean isProviderResource = false;
                IAnnotation[] iAnnotationArray = annotationList = type.getAnnotations();
                int n3 = annotationList.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnnotation annotation = iAnnotationArray[n4];
                    String matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), Constants.SET_OF_JAXRS_ANNOTATIONS1);
                    if (matchedAnnotation != null) {
                        if ("jakarta.ws.rs.Path".equals(matchedAnnotation)) {
                            isRootResource = true;
                        } else if ("jakarta.ws.rs.ext.Provider".equals(matchedAnnotation)) {
                            isProviderResource = true;
                        }
                    }
                    ++n4;
                }
                if (isRootResource || isProviderResource) {
                    Range methodRange;
                    IMethod[] methods;
                    ArrayList<IMethod> nonPublicConstructors = new ArrayList<IMethod>();
                    boolean hasPublicConstructor = false;
                    int maxParams = 0;
                    HashMap<IMethod, Integer> constructorParamsMap = new HashMap<IMethod, Integer>();
                    IMethod[] iMethodArray = methods = type.getMethods();
                    int n5 = methods.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IMethod method = iMethodArray[n6];
                        if (DiagnosticUtils.isConstructorMethod(method)) {
                            if (Flags.isPublic((int)method.getFlags())) {
                                hasPublicConstructor = true;
                                nonPublicConstructors.clear();
                                if (isRootResource) {
                                    int numParams = method.getNumberOfParameters();
                                    if (numParams > maxParams) {
                                        maxParams = numParams;
                                    }
                                    constructorParamsMap.put(method, numParams);
                                }
                            } else if (!hasPublicConstructor) {
                                nonPublicConstructors.add(method);
                            }
                        }
                        ++n6;
                    }
                    if (nonPublicConstructors.size() > 0) {
                        String diagnosticMessage = isRootResource ? Messages.getMessage("RootResourceClasses", new Object[0]) : Messages.getMessage("ProviderClasses", new Object[0]);
                        for (IMethod constructor : nonPublicConstructors) {
                            methodRange = PositionUtils.toNameRange(constructor, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, diagnosticMessage, methodRange, "jakarta-jaxrs", ErrorCode.NoPublicConstructors, DiagnosticSeverity.Error));
                        }
                    }
                    ArrayList<IMethod> equalMaxParamMethods = new ArrayList<IMethod>();
                    for (Map.Entry entry : constructorParamsMap.entrySet()) {
                        if ((Integer)entry.getValue() == maxParams) {
                            equalMaxParamMethods.add((IMethod)entry.getKey());
                            continue;
                        }
                        if ((Integer)entry.getValue() >= maxParams) continue;
                        IMethod method = (IMethod)entry.getKey();
                        Range methodRange2 = PositionUtils.toNameRange(method, context.getUtils());
                        diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ConstructorIsUnused", new Object[0]), methodRange2, "jakarta-jaxrs", ErrorCode.UnusedConstructor, DiagnosticSeverity.Warning));
                    }
                    if (equalMaxParamMethods.size() > 1) {
                        for (IMethod method : equalMaxParamMethods) {
                            methodRange = PositionUtils.toNameRange(method, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("MultipleConstructorsNumberOfParameters", new Object[0]), methodRange, "jakarta-jaxrs", ErrorCode.AmbiguousConstructors, DiagnosticSeverity.Warning));
                        }
                    }
                }
            }
            ++n2;
        }
        return diagnostics;
    }
}

