/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.annotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.JakartaCodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ModifyReturnTypeProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;

public class ModifyConstructReturnTypeQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(ModifyConstructReturnTypeQuickFix.class.getName());

    @Override
    public String getParticipantId() {
        return ModifyConstructReturnTypeQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<ExtendedCodeAction> codeActions = new ArrayList<ExtendedCodeAction>();
        ExtendedCodeAction codeAction = new ExtendedCodeAction(this.getLabel());
        codeAction.setRelevance(0);
        codeAction.setKind("quickfix");
        codeAction.setDiagnostics(Arrays.asList(diagnostic));
        JakartaCodeActionId id = JakartaCodeActionId.ChangeReturnTypeToVoid;
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), null, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), id));
        codeActions.add(codeAction);
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        ModifyReturnTypeProposal proposal = new ModifyReturnTypeProposal(this.getLabel(), context.getCompilationUnit(), context.getASTRoot(), parentType, 0, (Type)node.getAST().newPrimitiveType(PrimitiveType.VOID));
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to create workspace edit to change a method's retrun type", e);
        }
        return toResolve;
    }

    protected IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof MethodDeclaration) {
            return ((MethodDeclaration)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    private String getLabel() {
        return Messages.getMessage("ChangeReturnTypeToVoid", new Object[0]);
    }
}

