/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.codeaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.ICodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.RemoveAnnotationProposal;

public abstract class RemoveAnnotationConflictQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(RemoveAnnotationConflictQuickFix.class.getName());
    private final String[] annotations;
    protected final boolean generateOnlyOneCodeAction;
    public static final String ANNOTATIONS_KEY = "annotations";

    public RemoveAnnotationConflictQuickFix(String ... annotations) {
        this(false, annotations);
    }

    public RemoveAnnotationConflictQuickFix(boolean generateOnlyOneCodeAction, String ... annotations) {
        this.generateOnlyOneCodeAction = generateOnlyOneCodeAction;
        this.annotations = annotations;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        if (parentType != null) {
            this.createCodeActions(diagnostic, context, parentType, codeActions);
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        List annotationToRemoveList = (List)data.getExtendedDataEntry(ANNOTATIONS_KEY);
        String[] annotationToRemove = (String[])annotationToRemoveList.toArray(String[]::new);
        String label = this.getLabel(annotationToRemove);
        RemoveAnnotationProposal proposal = new RemoveAnnotationProposal(label, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, context.getCoveredNode().getParent(), annotationToRemove);
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to resolve code action to remove annotation", e);
        }
        return toResolve;
    }

    protected void createCodeActions(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions) throws CoreException {
        if (this.generateOnlyOneCodeAction) {
            this.createCodeAction(diagnostic, context, parentType, codeActions, this.annotations);
        } else {
            String[] stringArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                this.createCodeAction(diagnostic, context, parentType, codeActions, annotation);
                ++n2;
            }
        }
    }

    protected void createCodeAction(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, String ... annotations) throws CoreException {
        String label = this.getLabel(annotations);
        ExtendedCodeAction codeAction = new ExtendedCodeAction(label);
        codeAction.setRelevance(0);
        codeAction.setKind("quickfix");
        codeAction.setDiagnostics(Arrays.asList(diagnostic));
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        extendedData.put(ANNOTATIONS_KEY, Arrays.asList(annotations));
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), this.getCodeActionId()));
        codeActions.add(codeAction);
    }

    protected IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    protected String[] getAnnotations() {
        return this.annotations;
    }

    protected String getLabel(String[] annotations) {
        StringBuilder name = new StringBuilder("Remove ");
        int i = 0;
        while (i < annotations.length) {
            String annotation = annotations[i];
            String annotationName = annotation.substring(annotation.lastIndexOf(46) + 1, annotation.length());
            if (i > 0) {
                name.append(", ");
            }
            name.append("@");
            name.append(annotationName);
            ++i;
        }
        return name.toString();
    }

    protected abstract ICodeActionId getCodeActionId();
}

