/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.cdi;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.cdi.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.cdi.ErrorCode;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;

public class ManagedBeanDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        String uri = context.getUri();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] types = unit.getAllTypes();
        String[] scopeFQNames = (String[])Constants.SCOPE_FQ_NAMES.toArray(String[]::new);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            int isProducerMethod;
            Object[] annotationNames;
            IType type = iTypeArray[n2];
            List<String> managedBeanAnnotations = DiagnosticUtils.getMatchedJavaElementNames(type, (String[])Stream.of(type.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), scopeFQNames);
            boolean isManagedBean = managedBeanAnnotations.size() > 0;
            boolean isDependent = managedBeanAnnotations.stream().anyMatch(annotation -> "jakarta.enterprise.context.Dependent".equals(annotation));
            boolean hasMultipleScopes = managedBeanAnnotations.size() > 1;
            String[] injectAnnotations = new String[]{"jakarta.enterprise.inject.Produces", "jakarta.inject.Inject"};
            IField[] fields = type.getFields();
            boolean nonStaticPublicFieldPresent = false;
            IField[] iFieldArray = fields;
            int n3 = fields.length;
            int n4 = 0;
            while (n4 < n3) {
                Range range;
                IField field = iFieldArray[n4];
                int fieldFlags = field.getFlags();
                annotationNames = (String[])Stream.of(field.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new);
                List<String> fieldScopes = DiagnosticUtils.getMatchedJavaElementNames(type, (String[])annotationNames, scopeFQNames);
                if (this.validateNonStaticPublicField(isManagedBean, isDependent, hasMultipleScopes, fieldFlags)) {
                    Range range2 = PositionUtils.toNameRange(field, context.getUtils());
                    nonStaticPublicFieldPresent = true;
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanWithNonStaticPublicField", new Object[0]), range2, "jakarta-cdi", null, ErrorCode.InvalidManagedBeanWithNonStaticPublicField, DiagnosticSeverity.Error));
                }
                List<String> fieldInjects = DiagnosticUtils.getMatchedJavaElementNames(type, (String[])annotationNames, injectAnnotations);
                boolean isProducerField = false;
                boolean isInjectField = false;
                for (String annotation2 : fieldInjects) {
                    if ("jakarta.enterprise.inject.Produces".equals(annotation2)) {
                        isProducerField = true;
                        continue;
                    }
                    if (!"jakarta.inject.Inject".equals(annotation2)) continue;
                    isInjectField = true;
                }
                if (isProducerField && fieldScopes.size() > 1) {
                    fieldScopes.add("jakarta.enterprise.inject.Produces");
                    range = PositionUtils.toNameRange(field, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ScopeTypeAnnotationsProducerField", new Object[0]), range, "jakarta-cdi", new Gson().toJsonTree(fieldScopes), ErrorCode.InvalidNumberOfScopeAnnotationsByProducerField, DiagnosticSeverity.Error));
                }
                if (isProducerField && isInjectField) {
                    range = PositionUtils.toNameRange(field, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanProducesAndInjectField", new Object[0]), range, "jakarta-cdi", null, ErrorCode.InvalidFieldWithProducesAndInjectAnnotations, DiagnosticSeverity.Error));
                }
                ++n4;
            }
            IMethod[] methods = type.getMethods();
            ArrayList<IMethod> constructorMethods = new ArrayList<IMethod>();
            annotationNames = methods;
            int n5 = methods.length;
            int n6 = 0;
            while (n6 < n5) {
                Range range;
                IMethod method = annotationNames[n6];
                if (DiagnosticUtils.isConstructorMethod(method)) {
                    constructorMethods.add(method);
                }
                String[] annotationNames2 = (String[])Stream.of(method.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new);
                List<String> methodScopes = DiagnosticUtils.getMatchedJavaElementNames(type, annotationNames2, scopeFQNames);
                List<String> methodInjects = DiagnosticUtils.getMatchedJavaElementNames(type, annotationNames2, injectAnnotations);
                isProducerMethod = 0;
                boolean isInjectMethod = false;
                for (String annotation3 : methodInjects) {
                    if ("jakarta.enterprise.inject.Produces".equals(annotation3)) {
                        isProducerMethod = 1;
                        continue;
                    }
                    if (!"jakarta.inject.Inject".equals(annotation3)) continue;
                    isInjectMethod = true;
                }
                if (isProducerMethod != 0 && methodScopes.size() > 1) {
                    methodScopes.add("jakarta.enterprise.inject.Produces");
                    range = PositionUtils.toNameRange(method, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ScopeTypeAnnotationsProducerMethod", new Object[0]), range, "jakarta-cdi", new Gson().toJsonTree(methodScopes), ErrorCode.InvalidNumberOfScopeAnnotationsByProducerMethod, DiagnosticSeverity.Error));
                }
                if (isProducerMethod != 0 && isInjectMethod) {
                    range = PositionUtils.toNameRange(method, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanProducesAndInjectMethod", new Object[0]), range, "jakarta-cdi", null, ErrorCode.InvalidMethodWithProducesAndInjectAnnotations, DiagnosticSeverity.Error));
                }
                ++n6;
            }
            if (isManagedBean && constructorMethods.size() > 0) {
                ArrayList<IMethod> methodsNeedingDiagnostics = new ArrayList<IMethod>();
                for (IMethod m : constructorMethods) {
                    if (m.getNumberOfParameters() == 0) {
                        methodsNeedingDiagnostics.clear();
                        break;
                    }
                    IAnnotation[] annotations = m.getAnnotations();
                    boolean hasParameterizedInjectConstructor = false;
                    IAnnotation[] iAnnotationArray = annotations;
                    isProducerMethod = annotations.length;
                    int methodInjects = 0;
                    while (methodInjects < isProducerMethod) {
                        IAnnotation annotation4 = iAnnotationArray[methodInjects];
                        if (DiagnosticUtils.isMatchedJavaElement(type, annotation4.getElementName(), "jakarta.inject.Inject")) {
                            hasParameterizedInjectConstructor = true;
                            break;
                        }
                        ++methodInjects;
                    }
                    if (hasParameterizedInjectConstructor) {
                        methodsNeedingDiagnostics.clear();
                        break;
                    }
                    methodsNeedingDiagnostics.add(m);
                }
                for (IMethod m : methodsNeedingDiagnostics) {
                    Range range = PositionUtils.toNameRange(m, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanConstructorWithParameters", new Object[0]), range, "jakarta-cdi", null, ErrorCode.InvalidManagedBeanWithInvalidConstructor, DiagnosticSeverity.Error));
                }
            }
            if (isManagedBean) {
                boolean isClassGeneric = type.getTypeParameters().length != 0;
                Range range = PositionUtils.toNameRange(type, context.getUtils());
                if (isClassGeneric && (!isDependent || hasMultipleScopes)) {
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanGenericType", new Object[0]), range, "jakarta-cdi", null, ErrorCode.InvalidGenericManagedBeanClassWithNoDependentScope, DiagnosticSeverity.Error));
                } else if (nonStaticPublicFieldPresent) {
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanWithNonStaticPublicField", new Object[0]), range, "jakarta-cdi", null, ErrorCode.InvalidManagedBeanWithNonStaticPublicField, DiagnosticSeverity.Error));
                } else if (hasMultipleScopes) {
                    diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ScopeTypeAnnotationsManagedBean", new Object[0]), range, "jakarta-cdi", new Gson().toJsonTree(managedBeanAnnotations), ErrorCode.InvalidNumberOfScopedAnnotationsByManagedBean, DiagnosticSeverity.Error));
                }
            }
            this.invalidParamsCheck(context, uri, unit, diagnostics, type, "jakarta.inject.Inject");
            if (isManagedBean) {
                this.invalidParamsCheck(context, uri, unit, diagnostics, type, "jakarta.enterprise.inject.Produces");
                IMethod[] iMethodArray = methods;
                int n7 = methods.length;
                int n8 = 0;
                while (n8 < n7) {
                    ILocalVariable[] params;
                    IMethod method = iMethodArray[n8];
                    int numDisposes = 0;
                    TreeSet<String> invalidAnnotations = new TreeSet<String>();
                    ILocalVariable[] iLocalVariableArray = params = method.getParameters();
                    int n9 = params.length;
                    int n10 = 0;
                    while (n10 < n9) {
                        IAnnotation[] annotations;
                        ILocalVariable param = iLocalVariableArray[n10];
                        IAnnotation[] iAnnotationArray = annotations = param.getAnnotations();
                        int n11 = annotations.length;
                        int n12 = 0;
                        while (n12 < n11) {
                            IAnnotation annotation5 = iAnnotationArray[n12];
                            String matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation5.getElementName(), Constants.INVALID_PRODUCER_PARAMS_FQ);
                            if ("jakarta.enterprise.inject.Disposes".equals(matchedAnnotation)) {
                                ++numDisposes;
                            } else if ("jakarta.enterprise.event.Observes".equals(matchedAnnotation) || "jakarta.enterprise.event.ObservesAsync".equals(matchedAnnotation)) {
                                invalidAnnotations.add("@" + DiagnosticUtils.getSimpleName(annotation5.getElementName()));
                            }
                            ++n12;
                        }
                        ++n10;
                    }
                    if (numDisposes != 0) {
                        if (numDisposes > 1) {
                            Range range = PositionUtils.toNameRange(method, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("ManagedBeanDisposeOneParameter", new Object[0]), range, "jakarta-cdi", null, ErrorCode.InvalidDisposesAnnotationOnMultipleMethodParams, DiagnosticSeverity.Error));
                        }
                        if (!invalidAnnotations.isEmpty()) {
                            Range range = PositionUtils.toNameRange(method, context.getUtils());
                            diagnostics.add(context.createDiagnostic(uri, this.createInvalidDisposesLabel(invalidAnnotations), range, "jakarta-cdi", null, ErrorCode.InvalidDisposerMethodParamAnnotation, DiagnosticSeverity.Error));
                        }
                    }
                    ++n8;
                }
            }
            ++n2;
        }
        return diagnostics;
    }

    private void invalidParamsCheck(JavaDiagnosticsContext context, String uri, ICompilationUnit unit, List<Diagnostic> diagnostics, IType type, String target) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IAnnotation targetAnnotation = null;
            boolean mutuallyExclusive = false;
            IAnnotation[] iAnnotationArray = method.getAnnotations();
            int n3 = iAnnotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation2 = iAnnotationArray[n4];
                if (DiagnosticUtils.isMatchedJavaElement(type, annotation2.getElementName(), target)) {
                    targetAnnotation = annotation2;
                    break;
                }
                ++n4;
            }
            if (targetAnnotation != null) {
                ILocalVariable[] params;
                TreeSet<String> invalidAnnotations = new TreeSet<String>();
                ILocalVariable[] iLocalVariableArray = params = method.getParameters();
                int n5 = params.length;
                int n6 = 0;
                while (n6 < n5) {
                    ILocalVariable param = iLocalVariableArray[n6];
                    List<String> paramScopes = "jakarta.enterprise.inject.Produces".equals(target) ? DiagnosticUtils.getMatchedJavaElementNames(type, (String[])Stream.of(param.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), Constants.INVALID_PRODUCER_PARAMS_FQ) : DiagnosticUtils.getMatchedJavaElementNames(type, (String[])Stream.of(param.getAnnotations()).map(annotation -> annotation.getElementName()).toArray(String[]::new), Constants.INVALID_INITIALIZER_PARAMS_FQ);
                    for (String annotation3 : paramScopes) {
                        invalidAnnotations.add("@" + DiagnosticUtils.getSimpleName(annotation3));
                    }
                    LinkedHashSet<String> paramScopesSet = new LinkedHashSet<String>(paramScopes);
                    if (paramScopesSet.size() == Constants.INVALID_INITIALIZER_PARAMS_FQ.length && paramScopesSet.equals(Set.of(Constants.INVALID_INITIALIZER_PARAMS_FQ))) {
                        mutuallyExclusive = true;
                    }
                    ++n6;
                }
                if (!invalidAnnotations.isEmpty()) {
                    Range range = PositionUtils.toNameRange(method, context.getUtils());
                    if ("jakarta.enterprise.inject.Produces".equals(target)) {
                        diagnostics.add(context.createDiagnostic(uri, this.createInvalidProducesLabel(invalidAnnotations), range, "jakarta-cdi", null, ErrorCode.InvalidProducerMethodParamAnnotation, DiagnosticSeverity.Error));
                    } else if (mutuallyExclusive) {
                        diagnostics.add(context.createDiagnostic(uri, this.createInvalidInjectLabel(invalidAnnotations), range, "jakarta-cdi", null, ErrorCode.InvalidInjectAnnotationOnMultipleMethodParams, DiagnosticSeverity.Error));
                    } else {
                        diagnostics.add(context.createDiagnostic(uri, this.createInvalidInjectLabel(invalidAnnotations), range, "jakarta-cdi", null, ErrorCode.InvalidInjectAnnotatedMethodParamAnnotation, DiagnosticSeverity.Error));
                    }
                }
            }
            ++n2;
        }
    }

    private String createInvalidInjectLabel(Set<String> invalidAnnotations) {
        return Messages.getMessage("ManagedBeanInvalidInject", String.join((CharSequence)", ", invalidAnnotations));
    }

    private String createInvalidProducesLabel(Set<String> invalidAnnotations) {
        return Messages.getMessage("ManagedBeanInvalidProduces", String.join((CharSequence)", ", invalidAnnotations));
    }

    private String createInvalidDisposesLabel(Set<String> invalidAnnotations) {
        return Messages.getMessage("ManagedBeanInvalidDisposer", String.join((CharSequence)", ", invalidAnnotations));
    }

    private boolean validateNonStaticPublicField(boolean isManagedBean, boolean isDependent, boolean hasMultipleScopes, int fieldFlags) {
        return isManagedBean && Flags.isPublic((int)fieldFlags) && !Flags.isStatic((int)fieldFlags) && (!isDependent || hasMultipleScopes);
    }
}

