/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.servlet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.servlet.ErrorCode;

public class ListenerDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            IAnnotation[] allAnnotations = type.getAnnotations();
            boolean isWebListenerAnnotated = false;
            IAnnotation[] iAnnotationArray = allAnnotations;
            int n3 = allAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                if (DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.servlet.annotation.WebListener")) {
                    isWebListenerAnnotated = true;
                    break;
                }
                ++n4;
            }
            String[] interfaces = new String[]{"jakarta.servlet.ServletContextListener", "jakarta.servlet.ServletContextAttributeListener", "jakarta.servlet.ServletRequestListener", "jakarta.servlet.ServletRequestAttributeListener", "jakarta.servlet.http.HttpSessionListener", "jakarta.servlet.http.HttpSessionAttributeListener", "jakarta.servlet.http.HttpSessionIdListener"};
            boolean isImplemented = DiagnosticUtils.doesImplementInterfaces(type, interfaces);
            if (isWebListenerAnnotated && !isImplemented) {
                Range range = PositionUtils.toNameRange(type, context.getUtils());
                diagnostics.add(context.createDiagnostic(uri, Messages.getMessage("AnnotatedWithWebListenerMustImplement", new Object[0]), range, "jakarta-servlet", null, ErrorCode.WebFilterAnnotatedClassReqIfaceNoImpl, DiagnosticSeverity.Error));
            }
            ++n2;
        }
        return diagnostics;
    }
}

