/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.websocket;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class Constants {
    public static final String DIAGNOSTIC_SOURCE = "jakarta-websocket";
    public static final DiagnosticSeverity ERROR = DiagnosticSeverity.Error;
    public static final DiagnosticSeverity WARNING = DiagnosticSeverity.Warning;
    public static final String DIAGNOSTIC_ERR_MSG = "Cannot calculate WebSocket diagnostics";
    public static final String PATHPARAM_ANNOTATION = "jakarta.websocket.server.PathParam";
    public static final String PATHPARAM_DIAGNOSTIC_CODE = "ChangePathParamValue";
    public static final String ANNOTATION_VALUE = "value";
    public static final String URI_SEPARATOR = "/";
    public static final String CURLY_BRACE_START = "{";
    public static final String CURLY_BRACE_END = "}";
    public static final String SERVER_ENDPOINT_ANNOTATION = "jakarta.websocket.server.ServerEndpoint";
    public static final String CLIENT_ENDPOINT_ANNOTATION = "jakarta.websocket.ClientEndpoint";
    public static final String ENDPOINT_SUPERCLASS = "Endpoint";
    public static final String IS_SUPERCLASS = "isSuperclass";
    public static final String[] WS_ANNOTATION_CLASS = new String[]{"jakarta.websocket.server.ServerEndpoint", "jakarta.websocket.ClientEndpoint"};
    public static final String STRING_CLASS_LONG = "java.lang.String";
    public static final String STRING_CLASS_SHORT = "String";
    public static final String READER_CLASS_LONG = "java.io.Reader";
    public static final String READER_CLASS_SHORT = "Reader";
    public static final String BYTEBUFFER_CLASS_LONG = "java.nio.ByteBuffer";
    public static final String BYTEBUFFER_CLASS_SHORT = "ByteBuffer";
    public static final String INPUTSTREAM_CLASS_LONG = "java.io.InputStream";
    public static final String INPUTSTREAM_CLASS_SHORT = "InputStream";
    public static final String PONGMESSAGE_CLASS_LONG = "jakarta.websocket.PongMessage";
    public static final String PONGMESSAGE_CLASS_SHORT = "PongMessage";
    public static final Set<String> LONG_MESSAGE_CLASSES = new HashSet<String>(Arrays.asList("java.lang.String", "java.io.Reader", "java.nio.ByteBuffer", "java.io.InputStream", "jakarta.websocket.PongMessage"));
    public static final Set<String> SHORT_MESSAGE_CLASSES = new HashSet<String>(Arrays.asList("String", "Reader", "ByteBuffer", "InputStream", "PongMessage"));
    public static final String SESSION_CLASS = "jakarta.websocket.Session";
    public static final String ON_OPEN = "jakarta.websocket.OnOpen";
    public static final String ON_CLOSE = "jakarta.websocket.OnClose";
    public static final String ON_MESSAGE = "jakarta.websocket.OnMessage";
    public static final String IS_ANNOTATION = "isAnnotation";
    public static final String PATH_PARAM_ANNOTATION = "jakarta.websocket.server.PathParam";
    public static final Set<String> ON_OPEN_PARAM_OPT_TYPES = new HashSet<String>(Arrays.asList("jakarta.websocket.EndpointConfig", "jakarta.websocket.Session"));
    public static final Set<String> RAW_ON_OPEN_PARAM_OPT_TYPES = new HashSet<String>(Arrays.asList("EndpointConfig", "Session"));
    public static final Set<String> ON_CLOSE_PARAM_OPT_TYPES = new HashSet<String>(Arrays.asList("jakarta.websocket.CloseReason", "jakarta.websocket.Session"));
    public static final Set<String> RAW_ON_CLOSE_PARAM_OPT_TYPES = new HashSet<String>(Arrays.asList("CloseReason", "Session"));
    public static final Set<String> RAW_WRAPPER_OBJS = new HashSet<String>(Arrays.asList("String", "Boolean", "Integer", "Long", "Double", "Float"));
    public static final Set<String> WRAPPER_OBJS = RAW_WRAPPER_OBJS.stream().map(raw -> "java.lang.".concat((String)raw)).collect(Collectors.toSet());
    public static final String REGEX_RELATIVE_PATHS = ".*\\/\\.{0,2}\\/.*";
    public static final String REGEX_URI_VARIABLE = "\\{(\\w|-|%20|%21|%23|%24|%25|%26|%27|%28|%29|%2A|%2B|%2C|%2F|%3A|%3B|%3D|%3F|%40|%5B|%5D)+\\}";

    public static enum MESSAGE_FORMAT {
        TEXT,
        BINARY,
        PONG;

    }
}

