/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.InsertAnnotationProposal;

public class ModifyAnnotationProposal
extends InsertAnnotationProposal {
    private final List<String> attributesToAdd;
    private final List<String> attributesToRemove;

    public ModifyAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, String annotation, List<String> attributesToAdd, List<String> attributesToRemove) {
        super(label, targetCU, invocationNode, binding, relevance, annotation);
        this.attributesToAdd = attributesToAdd;
        this.attributesToRemove = attributesToRemove;
    }

    public ModifyAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, String annotation, List<String> attributesToAdd) {
        super(label, targetCU, invocationNode, binding, relevance, annotation);
        this.attributesToAdd = attributesToAdd;
        this.attributesToRemove = new ArrayList<String>();
    }

    public ModifyAnnotationProposal(String label, ICompilationUnit targetCU, CompilationUnit invocationNode, IBinding binding, int relevance, List<String> attributesToAdd, String ... annotations) {
        super(label, targetCU, invocationNode, binding, relevance, annotations);
        this.attributesToAdd = attributesToAdd;
        this.attributesToRemove = new ArrayList<String>();
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit fInvocationNode = this.getInvocationNode();
        IBinding fBinding = this.getBinding();
        String[] annotations = this.getAnnotations();
        String[] annotationShortNames = new String[annotations.length];
        int i = 0;
        while (i < annotations.length) {
            String shortName;
            annotationShortNames[i] = shortName = annotations[i].substring(annotations[i].lastIndexOf(".") + 1, annotations[i].length());
            ++i;
        }
        ASTNode declNode = null;
        ASTNode boundNode = fInvocationNode.findDeclaringNode(fBinding);
        CompilationUnit newRoot = fInvocationNode;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            newRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(fBinding.getKey());
        }
        ImportRewrite imports = this.createImportRewrite(newRoot);
        boolean isField = declNode instanceof VariableDeclarationFragment;
        boolean isSingleVarDecl = declNode instanceof SingleVariableDeclaration;
        if (isField) {
            declNode = declNode.getParent();
        }
        if (declNode.getNodeType() == 23) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(declNode, imports);
            ArrayList<Annotation> existingAnnotations = new ArrayList<Annotation>();
            List children = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.MODIFIERS2_PROPERTY);
            for (ASTNode child : children) {
                if (!(child instanceof Annotation)) continue;
                Annotation annotation = (Annotation)child;
                boolean containsAnnotation = Arrays.stream(annotationShortNames).anyMatch(annotation.getTypeName().toString()::contains);
                if (!containsAnnotation || !(child instanceof NormalAnnotation)) continue;
                List existingValues = ((NormalAnnotation)child).values().stream().map(mvp -> ((MemberValuePair)mvp).getName().toString()).collect(Collectors.toList());
                boolean containsAllToAdd = this.attributesToAdd.stream().allMatch(attr -> existingValues.stream().anyMatch(v -> v.equals(attr)));
                boolean containsAnyToRemove = this.attributesToRemove.stream().anyMatch(attr -> existingValues.stream().anyMatch(v -> v.equals(attr)));
                if (containsAllToAdd && !containsAnyToRemove) continue;
                existingAnnotations.add(annotation);
                rewrite.remove(child, null);
            }
            for (Annotation a : existingAnnotations) {
                if (!(a instanceof NormalAnnotation)) continue;
                NormalAnnotation marker = ast.newNormalAnnotation();
                marker.setTypeName(ast.newName(imports.addImport(a.getTypeName().toString(), (ImportRewrite.ImportRewriteContext)importRewriteContext)));
                List values = marker.values();
                List existingValues = ((NormalAnnotation)a).values();
                for (MemberValuePair mvp2 : existingValues) {
                    boolean removeAttribute = this.attributesToRemove.contains(mvp2.getName().getFullyQualifiedName());
                    if (removeAttribute) continue;
                    MemberValuePair memberValuePair = ast.newMemberValuePair();
                    memberValuePair.setName(ast.newSimpleName(mvp2.getName().getFullyQualifiedName()));
                    StringLiteral stringValue = ast.newStringLiteral();
                    if (mvp2.getValue() instanceof StringLiteral) {
                        StringLiteral stringLiteral = (StringLiteral)mvp2.getValue();
                        stringValue.setLiteralValue(stringLiteral.getLiteralValue());
                    } else {
                        stringValue.setLiteralValue("");
                    }
                    memberValuePair.setValue((Expression)stringValue);
                    values.add(memberValuePair);
                }
                for (String newAttr : this.attributesToAdd) {
                    if (!values.stream().noneMatch(v -> v.getName().toString().equals(newAttr))) continue;
                    MemberValuePair memberValuePair = ast.newMemberValuePair();
                    memberValuePair.setName(ast.newSimpleName(newAttr));
                    StringLiteral stringValue = ast.newStringLiteral();
                    stringValue.setLiteralValue("");
                    memberValuePair.setValue((Expression)stringValue);
                    values.add(memberValuePair);
                }
                rewrite.getListRewrite(declNode, isField ? FieldDeclaration.MODIFIERS2_PROPERTY : TypeDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
            }
            return rewrite;
        }
        if (declNode instanceof TypeDeclaration || isField || isSingleVarDecl) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(declNode, imports);
            ArrayList<Annotation> existingAnnotations = new ArrayList<Annotation>();
            ChildListPropertyDescriptor property = isSingleVarDecl ? SingleVariableDeclaration.MODIFIERS2_PROPERTY : TypeDeclaration.MODIFIERS2_PROPERTY;
            List children = (List)declNode.getStructuralProperty((StructuralPropertyDescriptor)property);
            for (ASTNode child : children) {
                if (!(child instanceof Annotation)) continue;
                Annotation annotation = (Annotation)child;
                boolean containsAnnotation = Arrays.stream(annotationShortNames).anyMatch(annotation.getTypeName().toString()::contains);
                if (!containsAnnotation) continue;
                existingAnnotations.add(annotation);
                rewrite.remove(child, null);
            }
            String[] stringArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                String annotation = stringArray[n2];
                NormalAnnotation marker = ast.newNormalAnnotation();
                marker.setTypeName(ast.newName(imports.addImport(annotation, (ImportRewrite.ImportRewriteContext)importRewriteContext)));
                List values = marker.values();
                if (!existingAnnotations.isEmpty()) {
                    for (Annotation a : existingAnnotations) {
                        if (!(a instanceof NormalAnnotation)) continue;
                        List existingValues = ((NormalAnnotation)a).values();
                        for (MemberValuePair mvp3 : existingValues) {
                            boolean removeAttribute = this.attributesToRemove.contains(mvp3.getName().getFullyQualifiedName());
                            if (removeAttribute) continue;
                            MemberValuePair memberValuePair = ast.newMemberValuePair();
                            memberValuePair.setName(ast.newSimpleName(mvp3.getName().getFullyQualifiedName()));
                            StringLiteral stringValue = ast.newStringLiteral();
                            if (mvp3.getValue() instanceof StringLiteral) {
                                StringLiteral stringLiteral = (StringLiteral)mvp3.getValue();
                                stringValue.setLiteralValue(stringLiteral.getLiteralValue());
                            } else {
                                stringValue.setLiteralValue("");
                            }
                            memberValuePair.setValue((Expression)stringValue);
                            values.add(memberValuePair);
                        }
                    }
                }
                for (String newAttr : this.attributesToAdd) {
                    MemberValuePair memberValuePair = ast.newMemberValuePair();
                    memberValuePair.setName(ast.newSimpleName(newAttr));
                    StringLiteral stringValue = ast.newStringLiteral();
                    stringValue.setLiteralValue("");
                    memberValuePair.setValue((Expression)stringValue);
                    values.add(memberValuePair);
                }
                ChildListPropertyDescriptor newRewrite = isSingleVarDecl ? SingleVariableDeclaration.MODIFIERS2_PROPERTY : (isField ? FieldDeclaration.MODIFIERS2_PROPERTY : TypeDeclaration.MODIFIERS2_PROPERTY);
                rewrite.getListRewrite(declNode, newRewrite).insertFirst((ASTNode)marker, null);
                ++n2;
            }
            return rewrite;
        }
        return null;
    }
}

