/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.folding;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.test.utils.AbstractTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FoldingCommandsTest
extends AbstractTest {
    private static final int MAX_WAIT_MS = 5000;
    private static final String CONTENT = "/**\n * SPDX-License-Identifier: EPL-2.0\n */\nimport\nimport\nimport\n/**\n * Some comment\n */\nvisible\n";

    @Test
    public void foldAndUnfoldAllCommands() throws Exception {
        FoldingCommandsTest.configureAutoFolding(false);
        FoldingRange foldingRangeLicense = new FoldingRange(0, 2);
        foldingRangeLicense.setKind("comment");
        FoldingRange foldingRangeImport = new FoldingRange(3, 5);
        foldingRangeImport.setKind("imports");
        MockLanguageServer.INSTANCE.setFoldingRanges(List.of(foldingRangeLicense, foldingRangeImport));
        IEditorPart editor = TestUtils.openEditor(TestUtils.createUniqueTestFile(null, CONTENT));
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        Assertions.assertTrue((boolean)(viewer instanceof ProjectionViewer));
        ProjectionViewer pViewer = (ProjectionViewer)viewer;
        TestUtils.waitForAndAssertCondition(5000, () -> FoldingCommandsTest.getAnnotationModel(pViewer) != null);
        ProjectionAnnotationModel model = FoldingCommandsTest.getAnnotationModel(pViewer);
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        store.setValue("foldingReconcilingStrategy.enabled", false);
        store.setValue("foldingReconcilingStrategy.enabled", true);
        TestUtils.waitForAndAssertCondition(5000, () -> FoldingCommandsTest.countAnnotations(model) == 2);
        Assertions.assertEquals((int)2, (int)FoldingCommandsTest.countAnnotations(model));
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        handlerService.executeCommand("org.eclipse.lsp4e.folding.collapseAll", null);
        TestUtils.waitForAndAssertCondition(5000, () -> FoldingCommandsTest.countCollapsed(model) == 2);
        Assertions.assertEquals((int)2, (int)FoldingCommandsTest.countCollapsed(model));
        handlerService.executeCommand("org.eclipse.lsp4e.folding.expandAll", null);
        TestUtils.waitForAndAssertCondition(5000, () -> FoldingCommandsTest.countCollapsed(model) == 0);
        Assertions.assertEquals((int)0, (int)FoldingCommandsTest.countCollapsed(model));
    }

    private static ProjectionAnnotationModel getAnnotationModel(ProjectionViewer viewer) {
        return viewer.getProjectionAnnotationModel();
    }

    private static int countAnnotations(ProjectionAnnotationModel model) {
        int count = 0;
        Iterator it = model.getAnnotationIterator();
        while (it != null && it.hasNext()) {
            if (!(it.next() instanceof ProjectionAnnotation)) continue;
            ++count;
        }
        return count;
    }

    private static int countCollapsed(ProjectionAnnotationModel model) {
        int count = 0;
        Iterator it = model.getAnnotationIterator();
        while (it != null && it.hasNext()) {
            ProjectionAnnotation pa;
            Annotation a = (Annotation)it.next();
            if (!(a instanceof ProjectionAnnotation) || !(pa = (ProjectionAnnotation)a).isCollapsed()) continue;
            ++count;
        }
        return count;
    }

    private static void configureAutoFolding(boolean enabled) {
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        store.setValue("foldingReconcilingStrategy.enabled", true);
        store.setValue("foldingReconcilingStrategy.collapseComments", enabled);
        store.setValue("foldingReconcilingStrategy.collapseLicenseHeaders", enabled);
        store.setValue("foldingReconcilingStrategy.collapseRegions", enabled);
        store.setValue("foldingReconcilingStrategy.collapseImports", enabled);
    }
}

