/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.linkedediting;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class LSPLinkedEditingBase
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String LINKED_EDITING_PREFERENCE = "org.eclipse.ui.genericeditor.linkedediting";
    private CompletableFuture<Void> request;
    protected boolean fEnabled;

    protected void install() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.fEnabled = preferences.getBoolean(LINKED_EDITING_PREFERENCE, true);
    }

    protected void uninstall() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.cancel();
    }

    protected CompletableFuture<Optional<LinkedEditingRanges>> collectLinkedEditingRanges(IDocument document, int offset) {
        this.cancel();
        if (document == null) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            TextDocumentPositionParams params = LSPEclipseUtils.toTextDocumentPosistionParams(offset, document);
            return ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getLinkedEditingRangeProvider)).collectAll(languageServer -> languageServer.getTextDocumentService().linkedEditingRange(LSPEclipseUtils.toLinkedEditingRangeParams(params))).thenApply(linkedEditRanges -> linkedEditRanges.stream().filter(Objects::nonNull).filter(linkedEditRange -> this.rangesContainOffset((LinkedEditingRanges)linkedEditRange, offset, document)).findFirst());
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private boolean rangesContainOffset(@NonNull LinkedEditingRanges ranges, int offset, IDocument document) {
        for (Range range : ranges.getRanges()) {
            if (!LSPEclipseUtils.isOffsetInRange(offset, range, document)) continue;
            return true;
        }
        return false;
    }

    private void cancel() {
        if (this.request != null && !this.request.isDone()) {
            this.request.cancel(true);
            this.request = null;
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(LINKED_EDITING_PREFERENCE)) {
            this.fEnabled = Boolean.valueOf(event.getNewValue().toString());
        }
    }
}

