/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.symbols;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SymbolsModelTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Test
    public void test() {
        ArrayList<SymbolInformation> items = new ArrayList<SymbolInformation>();
        Range range = new Range(new Position(0, 0), new Position(10, 0));
        items.add(this.createSymbolInformation("Namespace", SymbolKind.Namespace, range));
        range = new Range(new Position(1, 0), new Position(9, 0));
        items.add(this.createSymbolInformation("Class", SymbolKind.Class, range));
        range = new Range(new Position(2, 0), new Position(8, 0));
        items.add(this.createSymbolInformation("Method", SymbolKind.Method, range));
        SymbolsModel symbolsModel = new SymbolsModel();
        ArrayList eitherItems = new ArrayList(items.size());
        items.forEach(item -> {
            boolean bl = eitherItems.add(Either.forLeft((Object)item));
        });
        symbolsModel.update(eitherItems);
        Assert.assertEquals((long)1L, (long)symbolsModel.getElements().length);
        Assert.assertEquals(items.get(0), (Object)symbolsModel.getElements()[0]);
        Object[] children = symbolsModel.getChildren(symbolsModel.getElements()[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals(items.get(1), (Object)children[0]);
        children = symbolsModel.getChildren(children[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals(items.get(2), (Object)children[0]);
        Object parent = symbolsModel.getParent(children[0]);
        Assert.assertEquals(items.get(1), (Object)parent);
        parent = symbolsModel.getParent(parent);
        Assert.assertEquals(items.get(0), (Object)parent);
    }

    @Test
    public void testSymbolsMatchingStartingPositions() {
        ArrayList<SymbolInformation> items = new ArrayList<SymbolInformation>();
        Range range = new Range(new Position(0, 0), new Position(10, 0));
        items.add(this.createSymbolInformation("Namespace", SymbolKind.Namespace, range));
        range = new Range(new Position(0, 0), new Position(9, 0));
        items.add(this.createSymbolInformation("Class", SymbolKind.Class, range));
        range = new Range(new Position(1, 0), new Position(8, 0));
        items.add(this.createSymbolInformation("Method", SymbolKind.Method, range));
        SymbolsModel symbolsModel = new SymbolsModel();
        ArrayList eitherItems = new ArrayList(items.size());
        items.forEach(item -> {
            boolean bl = eitherItems.add(Either.forLeft((Object)item));
        });
        symbolsModel.update(eitherItems);
        Assert.assertEquals((long)1L, (long)symbolsModel.getElements().length);
        Assert.assertEquals(items.get(0), (Object)symbolsModel.getElements()[0]);
        Assert.assertTrue((boolean)symbolsModel.hasChildren(symbolsModel.getElements()[0]));
        Object[] children = symbolsModel.getChildren(symbolsModel.getElements()[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals(items.get(1), (Object)children[0]);
        Assert.assertTrue((boolean)symbolsModel.hasChildren(children[0]));
        children = symbolsModel.getChildren(children[0]);
        Assert.assertEquals((long)1L, (long)children.length);
        Assert.assertEquals(items.get(2), (Object)children[0]);
        Object parent = symbolsModel.getParent(children[0]);
        Assert.assertEquals(items.get(1), (Object)parent);
        parent = symbolsModel.getParent(parent);
        Assert.assertEquals(items.get(0), (Object)parent);
    }

    @Test
    public void testDuplicateSymbols() {
        ArrayList<SymbolInformation> items = new ArrayList<SymbolInformation>();
        Range range = new Range(new Position(0, 0), new Position(0, 0));
        items.add(this.createSymbolInformation("Duplicate", SymbolKind.Namespace, range));
        items.add(this.createSymbolInformation("Duplicate", SymbolKind.Namespace, range));
        SymbolsModel symbolsModel = new SymbolsModel();
        ArrayList eitherItems = new ArrayList(items.size());
        items.forEach(item -> {
            boolean bl = eitherItems.add(Either.forLeft((Object)item));
        });
        symbolsModel.update(eitherItems);
        Assert.assertEquals((long)2L, (long)symbolsModel.getElements().length);
        Assert.assertFalse((boolean)symbolsModel.hasChildren(symbolsModel.getElements()[0]));
        Assert.assertFalse((boolean)symbolsModel.hasChildren(symbolsModel.getElements()[1]));
        Assert.assertEquals((long)0L, (long)symbolsModel.getChildren(symbolsModel.getElements()[0]).length);
        Assert.assertEquals((long)0L, (long)symbolsModel.getChildren(symbolsModel.getElements()[1]).length);
    }

    @Test
    public void testGetElementsEmptyResponse() {
        ArrayList items = new ArrayList();
        SymbolsModel symbolsModel = new SymbolsModel();
        ArrayList eitherItems = new ArrayList(items.size());
        items.forEach(item -> {
            boolean bl = eitherItems.add(Either.forLeft((Object)item));
        });
        symbolsModel.update(eitherItems);
        Assert.assertEquals((long)0L, (long)symbolsModel.getElements().length);
    }

    @Test
    public void testGetElementsNullResponse() {
        SymbolsModel symbolsModel = new SymbolsModel();
        symbolsModel.update(null);
        Assert.assertEquals((long)0L, (long)symbolsModel.getElements().length);
    }

    @Test
    public void testGetParentEmptyResponse() {
        SymbolsModel symbolsModel = new SymbolsModel();
        symbolsModel.update(Collections.emptyList());
        Assert.assertEquals(null, (Object)symbolsModel.getParent(null));
    }

    @Test
    public void testGetParentNullResponse() {
        SymbolsModel symbolsModel = new SymbolsModel();
        symbolsModel.update(null);
        Assert.assertEquals(null, (Object)symbolsModel.getParent(null));
    }

    private SymbolInformation createSymbolInformation(String name, SymbolKind kind, Range range) {
        SymbolInformation symbolInformation = new SymbolInformation();
        symbolInformation.setName(name);
        symbolInformation.setKind(kind);
        symbolInformation.setLocation(new Location("file://test", range));
        return symbolInformation;
    }
}

