/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LanguageServerWrapperTest {
    private IProject project1;
    private IProject project2;
    @Rule
    public AllCleanRule clear = new AllCleanRule();

    @Before
    public void setUp() throws CoreException {
        this.project1 = TestUtils.createProject("LanguageServerWrapperTestProject1" + System.currentTimeMillis());
        this.project2 = TestUtils.createProject("LanguageServerWrapperTestProject2" + System.currentTimeMillis());
    }

    @Test
    public void testConnect() throws Exception {
        IFile testFile1 = TestUtils.createFile(this.project1, "shouldUseExtension.lsptWithMultiRoot", "");
        IFile testFile2 = TestUtils.createFile(this.project2, "shouldUseExtension.lsptWithMultiRoot", "");
        IEditorPart editor1 = TestUtils.openEditor(testFile1);
        IEditorPart editor2 = TestUtils.openEditor(testFile2);
        @NonNull Collection wrappers = LanguageServiceAccessor.getLSWrappers((IFile)testFile1, request -> true);
        Assert.assertEquals((long)1L, (long)wrappers.size());
        LanguageServerWrapper wrapper = (LanguageServerWrapper)wrappers.iterator().next();
        int i = 0;
        while (i < 10 && !wrapper.isActive()) {
            Thread.sleep(100L);
            ++i;
        }
        Assert.assertTrue((boolean)wrapper.isConnectedTo(testFile1.getLocationURI()));
        Assert.assertTrue((boolean)wrapper.isConnectedTo(testFile2.getLocationURI()));
        TestUtils.closeEditor(editor1, false);
        TestUtils.closeEditor(editor2, false);
    }
}

