/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.mpt.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;

public class CifSpecificationHelper {
    private CifSpecificationHelper() {
    }

    public static List<List<String>> getPossiblePaths(Specification cifSpecification) {
        List locations = cifSpecification.getComponents().stream().filter(Automaton.class::isInstance).map(Automaton.class::cast).flatMap(a -> a.getLocations().stream()).collect(Collectors.toList());
        Location initialLocation = locations.stream().filter(l -> !l.getInitials().isEmpty()).findFirst().get();
        List finalLocations = locations.stream().filter(l -> l.getEdges().isEmpty()).collect(Collectors.toList());
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        for (Location endLoc : finalLocations) {
            CifSpecificationHelper.addPaths(initialLocation, endLoc, results);
        }
        CifSpecificationHelper.addPaths(initialLocation, initialLocation, results);
        return results;
    }

    private static void addPaths(Location from, Location to, List<List<String>> result) {
        ArrayList<Edge> visited = new ArrayList<Edge>();
        ArrayList<Location> path = new ArrayList<Location>();
        path.add(from);
        CifSpecificationHelper.findAllPaths(from, to, visited, path, result);
    }

    private static void findAllPaths(Location from, Location to, List<Edge> visited, List<Location> path, List<List<String>> result) {
        boolean start;
        boolean bl = start = path.size() == 1;
        if (!start && from.equals(to)) {
            List<String> activities = CifSpecificationHelper.getEvents(path);
            result.add(activities);
            return;
        }
        for (Edge edge : from.getEdges()) {
            if (visited.contains(edge)) continue;
            visited.add(edge);
            Location successor = edge.getTarget();
            path.add(successor);
            CifSpecificationHelper.findAllPaths(successor, to, visited, path, result);
            path.remove(path.size() - 1);
            visited.remove(visited.size() - 1);
        }
    }

    private static List<String> getEvents(List<Location> path) {
        ArrayList<String> activities = new ArrayList<String>(path.size() - 1);
        int i = 0;
        while (i < path.size() - 1) {
            activities.add(CifSpecificationHelper.getEvent(path.get(i), path.get(i + 1)));
            ++i;
        }
        return activities;
    }

    private static String getEvent(Location a, Location b) {
        EventExpression exp = a.getEdges().stream().filter(edge -> edge.getTarget() == b).flatMap(edge -> edge.getEvents().stream()).map(EdgeEvent::getEvent).filter(EventExpression.class::isInstance).map(EventExpression.class::cast).findFirst().get();
        return exp.getEvent().getName();
    }
}

