/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.NetworkAttachmentConfig;

final class ImmutableNetworkAttachmentConfig
implements NetworkAttachmentConfig {
    @Nullable
    private final String target;
    @Nullable
    private final List<String> aliases;

    private ImmutableNetworkAttachmentConfig(@Nullable String target, @Nullable List<String> aliases) {
        this.target = target;
        this.aliases = aliases;
    }

    @Override
    @JsonProperty(value="Target")
    @Nullable
    public String target() {
        return this.target;
    }

    @Override
    @JsonProperty(value="Aliases")
    @Nullable
    public List<String> aliases() {
        return this.aliases;
    }

    public final ImmutableNetworkAttachmentConfig withTarget(@Nullable String value) {
        if (Objects.equals(this.target, value)) {
            return this;
        }
        return new ImmutableNetworkAttachmentConfig(value, this.aliases);
    }

    public final ImmutableNetworkAttachmentConfig withAliases(String ... elements) {
        if (elements == null) {
            if (this.aliases == null) {
                return this;
            }
            return new ImmutableNetworkAttachmentConfig(this.target, null);
        }
        List<String> newValue = ImmutableNetworkAttachmentConfig.createUnmodifiableList(false, ImmutableNetworkAttachmentConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableNetworkAttachmentConfig(this.target, newValue);
    }

    public final ImmutableNetworkAttachmentConfig withAliases(@Nullable Iterable<String> elements) {
        if (this.aliases == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableNetworkAttachmentConfig.createUnmodifiableList(false, ImmutableNetworkAttachmentConfig.createSafeList(elements, true, false));
        return new ImmutableNetworkAttachmentConfig(this.target, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkAttachmentConfig && this.equalsByValue((ImmutableNetworkAttachmentConfig)another);
    }

    private boolean equalsByValue(ImmutableNetworkAttachmentConfig another) {
        return Objects.equals(this.target, another.target) && Objects.equals(this.aliases, another.aliases);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.target);
        h += (h << 5) + Objects.hashCode(this.aliases);
        return h;
    }

    public String toString() {
        return "NetworkAttachmentConfig{target=" + this.target + ", aliases=" + String.valueOf(this.aliases) + "}";
    }

    public static ImmutableNetworkAttachmentConfig copyOf(NetworkAttachmentConfig instance) {
        if (instance instanceof ImmutableNetworkAttachmentConfig) {
            return (ImmutableNetworkAttachmentConfig)instance;
        }
        return ImmutableNetworkAttachmentConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements NetworkAttachmentConfig.Builder {
        private String target;
        private List<String> aliases = null;

        private Builder() {
        }

        public final Builder from(NetworkAttachmentConfig instance) {
            List<String> aliasesValue;
            Objects.requireNonNull(instance, "instance");
            String targetValue = instance.target();
            if (targetValue != null) {
                this.target(targetValue);
            }
            if ((aliasesValue = instance.aliases()) != null) {
                this.addAllAliases(aliasesValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Target")
        public final Builder target(@Nullable String target) {
            this.target = target;
            return this;
        }

        public final Builder aliase(String element) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            return this;
        }

        @Override
        public final Builder aliases(String ... elements) {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            for (String element : elements) {
                this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Aliases")
        public final Builder aliases(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.aliases = null;
                return this;
            }
            this.aliases = new ArrayList<String>();
            return this.addAllAliases(elements);
        }

        public final Builder addAllAliases(Iterable<String> elements) {
            Objects.requireNonNull(elements, "aliases element");
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>();
            }
            for (String element : elements) {
                this.aliases.add(Objects.requireNonNull(element, "aliases element"));
            }
            return this;
        }

        @Override
        public ImmutableNetworkAttachmentConfig build() {
            return new ImmutableNetworkAttachmentConfig(this.target, this.aliases == null ? null : ImmutableNetworkAttachmentConfig.createUnmodifiableList(true, this.aliases));
        }
    }
}

