/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.changelog.core.Messages;
import org.eclipse.linuxtools.internal.changelog.core.actions.ChangeLogContainerSelectionGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ChangeLogContainerSelectionDialog
extends SelectionDialog {
    private static final String ContainerSelectionDialog_title = Messages.getString("ChangeLogContainerSelectionDialog.Title");
    private static final String ContainerSelectionDialog_message = Messages.getString("ChangeLogContainerSelectionDialog.Message");
    private static final String CONTAINER_SELECTION_DIALOG = "org.eclipse.ui.ide.container_selection_dialog_context";
    ChangeLogContainerSelectionGroup group;
    private IContainer initialSelection;
    private boolean allowNewContainerName = true;
    Label statusMessage;
    private boolean showClosedProjects = true;

    public ChangeLogContainerSelectionDialog(Shell parentShell, IContainer initialRoot, boolean allowNewContainerName, String message) {
        super(parentShell);
        this.setTitle(ContainerSelectionDialog_title);
        this.initialSelection = initialRoot;
        this.allowNewContainerName = allowNewContainerName;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(ContainerSelectionDialog_message);
        }
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, CONTAINER_SELECTION_DIALOG);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.group = new ChangeLogContainerSelectionGroup(area, this.allowNewContainerName, this.getMessage(), this.showClosedProjects, this.initialSelection);
        if (this.initialSelection != null) {
            this.group.setSelectedContainer(this.initialSelection);
        }
        this.statusMessage = new Label(area, 64);
        this.statusMessage.setLayoutData((Object)new GridData(768));
        this.statusMessage.setText(" \n ");
        this.statusMessage.setFont(parent.getFont());
        return this.dialogArea;
    }

    protected void okPressed() {
        ArrayList<IPath> chosenContainerPathList = new ArrayList<IPath>();
        IPath returnValue = this.group.getContainerFullPath();
        if (returnValue != null) {
            chosenContainerPathList.add(returnValue);
        }
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }
}

