/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.references.XMLReferencesSettingsForTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.Location;
import org.junit.jupiter.api.Test;

public class XMLReferencesReferenceExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void tei() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <teiHeader>  \r\n    <fileDesc>\r\n      <titleStmt>\r\n        <title>Title</title>\r\n      </titleStmt>\r\n      <publicationStmt>\r\n        <p>Publication information</p>  \r\n      </publicationStmt>\r\n      <sourceDesc>\r\n        <p>Information about the source</p>\r\n      </sourceDesc>\r\n    </fileDesc>\r\n  </teiHeader>\r\n  <text>\r\n    <body xml:id=\"bo|dy-id\">\r\n      <p xml:id=\"p-id\" >Some text here.</p>\r\n      <anchor corresp=\"#body-id\"></anchor>\r\n    </body>\r\n  </text>\r\n</TEI>";
        this.testReferencesFor(xml, "file:///test/tei.xml", XMLAssert.l("file:///test/tei.xml", XMLAssert.r(18, 23, 18, 31)));
    }

    @Test
    public void teiTargetMulti() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\t<teiHeader></teiHeader>\r\n\t<text>\r\n\t\t<body>\r\n\t\t\t<p xml:id=\"A\" />\r\n\t\t\t<p xml:id=\"B|\" />\r\n\t\t</body>\r\n\t\t<link target=\"#A #B\" />\r\n\t\t<link target=\"#A #B #C\" />\r\n\t\t<link target=\"#A\" />\r\n\t\t<link target=\"#B\" />\r\n\t\t<link target2=\"#B\" />\r\n\t</text>\r\n</TEI>";
        this.testReferencesFor(xml, "file:///test/tei.xml", XMLAssert.l("file:///test/tei.xml", XMLAssert.r(8, 19, 8, 21)), XMLAssert.l("file:///test/tei.xml", XMLAssert.r(9, 19, 9, 21)), XMLAssert.l("file:///test/tei.xml", XMLAssert.r(11, 16, 11, 18)));
    }

    private void testReferencesFor(String xml, String fileURI, Location ... expectedItems) throws BadLocationException {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        xmlLanguageService.getExtensions();
        xmlLanguageService.doSave((ISaveContext)new XMLAssert.SettingsSaveContext(XMLReferencesSettingsForTest.createXMLReferencesSettings()));
        XMLAssert.testReferencesFor(xmlLanguageService, xml, fileURI, expectedItems);
    }
}

