/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import java.io.File;
import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.references.XMLReferencesSettingsForTest;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesErrorCode;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.jupiter.api.Test;

public class XMLReferencesDiagnosticsExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void undefinedReferences() throws BadLocationException {
        String xml = "<aaa ref=\"child1 badChild1 child2 badChild2 child3 badChild3\">\r\n  <bbb>child1</bbb>\r\n  <bbb>child2</bbb>\r\n  <bbb>child3</bbb>\r\n</aaa>";
        XMLReferencesDiagnosticsExtensionsTest.testDiagnosticsFor(xml, "file:///test/attr-to-text.xml", XMLAssert.d(0, 17, 0, 26, (IXMLErrorCode)XMLReferencesErrorCode.UndefinedReference, "Undefined reference 'badChild1': nothing that matches the expression 'bbb/text()' defines 'badChild1'.", "xml", DiagnosticSeverity.Warning), XMLAssert.d(0, 34, 0, 43, (IXMLErrorCode)XMLReferencesErrorCode.UndefinedReference, "Undefined reference 'badChild2': nothing that matches the expression 'bbb/text()' defines 'badChild2'.", "xml", DiagnosticSeverity.Warning), XMLAssert.d(0, 51, 0, 60, (IXMLErrorCode)XMLReferencesErrorCode.UndefinedReference, "Undefined reference 'badChild3': nothing that matches the expression 'bbb/text()' defines 'badChild3'.", "xml", DiagnosticSeverity.Warning));
    }

    @Test
    public void invalidPrefix() throws BadLocationException {
        String xml = "<link target=\"#A B #C\" />";
        XMLReferencesDiagnosticsExtensionsTest.testDiagnosticsFor(xml, "file:///test/tei.xml", XMLAssert.d(0, 14, 0, 16, (IXMLErrorCode)XMLReferencesErrorCode.UndefinedReference, "Undefined reference '#A': nothing that matches the expression '@xml:id' defines 'A'.", "xml", DiagnosticSeverity.Warning), XMLAssert.d(0, 17, 0, 18, (IXMLErrorCode)XMLReferencesErrorCode.InvalidPrefix, "Invalid reference 'B': references to declarations that match the expression '@xml:id' require the '#' prefix.", "xml", DiagnosticSeverity.Warning), XMLAssert.d(0, 19, 0, 21, (IXMLErrorCode)XMLReferencesErrorCode.UndefinedReference, "Undefined reference '#C': nothing that matches the expression '@xml:id' defines 'C'.", "xml", DiagnosticSeverity.Warning));
    }

    @Test
    public void noUndefinedReferences() throws BadLocationException {
        String xml = "<aaa ref=\"chi|ld1 badChild1 child2 badChild2 child3 badChild3\">\r\n  <bbb>child1</bbb>\r\n  <bbb>child2</bbb>\r\n  <bbb>child3</bbb>\r\n</aaa>";
        XMLReferencesDiagnosticsExtensionsTest.testDiagnosticsFor(xml, "file:///test/foo.xml", new Diagnostic[0]);
    }

    @Test
    public void docbookWithoutInclude() throws BadLocationException {
        String xml = "<docbook>\r\n\t<xref linkend=\"s1\" />\r\n\t<section id=\"s1\" />\r\n\t<xref linkend=\"ch1\" />\r\n</docbook>";
        XMLReferencesDiagnosticsExtensionsTest.testDiagnosticsFor(xml, new File("src/test/resources/xml/docbook.xml").toURI().toString(), XMLAssert.d(3, 16, 3, 19, (IXMLErrorCode)XMLReferencesErrorCode.UndefinedReference, "Undefined reference 'ch1': nothing that matches the expression '@id' defines 'ch1'.", "xml", DiagnosticSeverity.Warning));
    }

    @Test
    public void docbookWithInclude() throws BadLocationException {
        String xml = "<docbook>\r\n\t<xref linkend=\"s1\" />\r\n\t<section id=\"s1\" />\r\n\t<xref linkend=\"ch1\" />\r\n\t<xi:include href=\"sub-book.xml\" xmlns:xi=\"http://www.w3.org/2001/XInclude\" />\r\n</docbook>";
        XMLReferencesDiagnosticsExtensionsTest.testDiagnosticsFor(xml, new File("src/test/resources/xml/docbook.xml").toURI().toString(), new Diagnostic[0]);
    }

    public static void testDiagnosticsFor(String xml, String fileURI, Diagnostic ... expected) {
        Consumer<XMLLanguageService> config = ls -> ls.doSave((ISaveContext)new XMLAssert.SettingsSaveContext(XMLReferencesSettingsForTest.createXMLReferencesSettings()));
        XMLAssert.testDiagnosticsFor(xml, null, config, fileURI, false, expected);
    }
}

