/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.entities;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.entities.EntitiesDocumentationUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class EntitiesCompletionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void localWithSYSTEM() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" standalone=\"no\" ?>\r\n\t<!DOCTYPE copyright [\r\n\t  <!ELEMENT copyright (#PCDATA)>\r\n\t  <!ENTITY c SYSTEM \"http://www.xmlwriter.net/copyright.xml\">\r\n\t]>\r\n\t<copyright>&|</copyright>";
        XMLAssert.testCompletionFor(xml, 3 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&c;", "&c;", XMLAssert.r(5, 12, 5, 13), "&c;"));
    }

    @Test
    public void afterAmp() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  &|\r\n</root>";
        XMLAssert.testCompletionFor(xml, 3 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&mdash;", "&mdash;", XMLAssert.r(5, 2, 5, 3), "&mdash;"));
    }

    @Test
    public void afterCharacter() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  &m|\r\n</root>";
        XMLAssert.testCompletionFor(xml, 3 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&mdash;", "&mdash;", XMLAssert.r(5, 2, 5, 4), "&mdash;"));
    }

    @Test
    public void inside() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  &m|dblablabla\r\n</root>";
        XMLAssert.testCompletionFor(xml, 3 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&mdash;", "&mdash;", XMLAssert.r(5, 2, 5, 4), "&mdash;"));
    }

    @Test
    public void underscoreEntityName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY foo_bar \"&#x2014;\">\r\n  <!ENTITY foo_baz \"&#x2014;\">\r\n]>\r\n<root>\r\n  &foo_b|\r\n</root>";
        XMLAssert.testCompletionFor(xml, 4 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&foo_bar;", "&foo_bar;", XMLAssert.r(6, 2, 6, 8), "&foo_bar;"), XMLAssert.c("&foo_baz;", "&foo_baz;", XMLAssert.r(6, 2, 6, 8), "&foo_baz;"));
    }

    @Test
    public void underscoreEntityNameItemDefaults() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY foo_bar \"&#x2014;\">\r\n  <!ENTITY foo_baz \"&#x2014;\">\r\n]>\r\n<root>\r\n  &foo_b|\r\n</root>";
        XMLAssert.testCompletionFor(xml, (Integer)(4 + EntitiesDocumentationUtils.PredefinedEntity.values().length), true, XMLAssert.c("&foo_bar;", "&foo_bar;", XMLAssert.r(6, 2, 6, 8), "&foo_bar;"), XMLAssert.c("&foo_baz;", "&foo_baz;", XMLAssert.r(6, 2, 6, 8), "&foo_baz;"));
    }

    @Test
    public void insideWithAmp() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  &m|d;blablabla\r\n</root>";
        XMLAssert.testCompletionFor(xml, 3 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&mdash;", "&mdash;", XMLAssert.r(5, 2, 5, 6), "&mdash;"));
    }

    @Test
    public void none() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  |\r\n</root>";
        XMLAssert.testCompletionFor(xml, 4, new CompletionItem[0]);
    }

    @Test
    public void external() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"src/test/resources/dtd/entities/base.dtd\" [\r\n\t<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &|</root-element>";
        XMLAssert.testCompletionFor(xml, null, "test.xml", 4 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&mdash;", "&mdash;", XMLAssert.r(6, 1, 6, 2), "&mdash;"), XMLAssert.c("&foo;", "&foo;", XMLAssert.r(6, 1, 6, 2), "&foo;"));
    }

    @Test
    public void externalWithSYSTEM() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE author SYSTEM \"src/test/resources/dtd/entities/base-system.dtd\">\r\n<author>&|</author>";
        XMLAssert.testCompletionFor(xml, null, "test.xml", 4 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&writer;", "&writer;", XMLAssert.r(2, 8, 2, 9), "&writer;"), XMLAssert.c("&copyright;", "&copyright;", XMLAssert.r(2, 8, 2, 9), "&copyright;"));
    }

    @Test
    public void bug_vscode_xml_262() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<!DOCTYPE alex-update-sequence SYSTEM \"src/test/resources/dtd/entities/bug_vscode-xml_262.dtd\" [<!-- {{{ -->\r\n]>\r\n<!-- }}} -->\r\n<root>\r\n&|\r\n</root>";
        XMLAssert.testCompletionFor(xml, null, "test.xml", 31 + EntitiesDocumentationUtils.PredefinedEntity.values().length, XMLAssert.c("&fdcuf_hide_actions_column;", "&fdcuf_hide_actions_column;", XMLAssert.r(5, 0, 5, 1), "&fdcuf_hide_actions_column;"));
    }
}

