/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.lemminx.uriresolver.ModifiedResourceHandler;
import org.eclipse.lemminx.utils.ProjectUtils;

public class FileServer {
    private static Logger LOG = Logger.getLogger(FileServer.class.getName());
    private Server server;

    public FileServer() throws IOException {
        this(ProjectUtils.getProjectDirectory().resolve("src/test/resources"));
    }

    public FileServer(Path baseDir) throws IOException {
        Files.createDirectories(baseDir, new FileAttribute[0]);
        ModifiedResourceHandler resourceHandler = new ModifiedResourceHandler();
        resourceHandler.setResourceBase(baseDir.toUri().toString());
        resourceHandler.setDirectoriesListed(true);
        this.serve(new Handler[]{resourceHandler, new DefaultHandler()});
    }

    public FileServer(Handler ... handlers) throws IOException {
        this.serve(handlers);
    }

    private void serve(Handler ... handlers) {
        this.server = new Server(0);
        this.server.setHandler((Handler)new HandlerList(handlers));
    }

    public int start() throws Exception {
        if (!(this.server.isStarting() || this.server.isStarted() || this.server.isRunning())) {
            this.server.start();
        }
        int port = this.getPort();
        LOG.info("http server started on port " + port);
        return port;
    }

    public int getPort() {
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public String getUri(String resourcePath) {
        StringBuilder sb = new StringBuilder("http://localhost:").append(this.getPort());
        if (!resourcePath.startsWith("/")) {
            sb.append("/");
        }
        sb.append(resourcePath);
        LOG.info("remote uri : " + sb.toString());
        return sb.toString();
    }
}

