/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.Location;
import org.junit.jupiter.api.Test;

public class XSDReferenceExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void referenceOnElementName() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"e|lt\" />\r\n\t<xs:complexType name=\"aComplexType\" >\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element ref=\"xs:elt\" />\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>\r\n\t<xs:element name=\"elt2\" substitutionGroup=\"xs:elt\" />\r\n\t<xs:group name=\"elt\" />\r\n</xs:schema>";
        this.testReferencesFor(xml, XMLAssert.l("test.xsd", XMLAssert.r(5, 19, 5, 27)), XMLAssert.l("test.xsd", XMLAssert.r(8, 43, 8, 51)));
    }

    @Test
    public void referenceOnGroupName() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" />\r\n\t<xs:complexType name=\"aComplexType\" >\r\n\t\t<xs:sequence>\r\n\t\t\t<xs:element ref=\"xs:elt\" />\r\n\t\t\t<xs:group ref=\"xs:elt\"></xs:group>\r\n\t\t</xs:sequence>\r\n\t</xs:complexType>\r\n\t<xs:element name=\"elt2\" substitutionGroup=\"xs:elt\" />\r\n\t<xs:group name=\"e|lt\" />\r\n</xs:schema>";
        this.testReferencesFor(xml, XMLAssert.l("test.xsd", XMLAssert.r(6, 17, 6, 25)));
    }

    @Test
    public void referenceOnComplexTypeName() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" type=\"xs:aComplexType\" />\r\n\t<xs:complexType name=\"aCompl|exType\">\r\n\t</xs:complexType>\r\n\t<xs:complexType name=\"aComplexType2\">\r\n\t\t<xs:complexContent>\r\n\t\t\t<xs:extension base=\"xs:aComplexType\"></xs:extension>\r\n\t\t</xs:complexContent>\r\n\t</xs:complexType>\r\n</xs:schema>";
        this.testReferencesFor(xml, XMLAssert.l("test.xsd", XMLAssert.r(2, 29, 2, 46)), XMLAssert.l("test.xsd", XMLAssert.r(7, 22, 7, 39)));
    }

    @Test
    public void referenceOnSimpleTypeName() throws BadLocationException {
        String xml = "<?xml version=\"1.1\" ?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<xs:element name=\"elt\" type=\"xs:aSimpleType\" />\r\n\t<xs:simpleType name=\"aSi|mpleType\">\r\n\t\t<xs:restriction base=\"xs:boolean\"></xs:restriction>\r\n\t</xs:simpleType>\r\n\t<xs:simpleType name=\"aSimpleType2\">\r\n\t\t<xs:restriction base=\"xs:aSimpleType\"></xs:restriction>\r\n\t</xs:simpleType>\r\n</xs:schema>";
        this.testReferencesFor(xml, XMLAssert.l("test.xsd", XMLAssert.r(2, 29, 2, 45)), XMLAssert.l("test.xsd", XMLAssert.r(7, 23, 7, 39)));
    }

    private void testReferencesFor(String xml, Location ... expectedItems) throws BadLocationException {
        XMLAssert.testReferencesFor(xml, "test.xsd", expectedItems);
    }
}

