/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.LocationLink;
import org.junit.jupiter.api.Test;

public class XMLDefinitionTest {
    @Test
    public void noStartTagDefinition() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<root>\r\n</chi|ld>";
        XMLDefinitionTest.testDefinitionFor(xml, new LocationLink[0]);
    }

    @Test
    public void noEndTagDefinition() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<roo|t>\r\n</child>";
        XMLDefinitionTest.testDefinitionFor(xml, new LocationLink[0]);
    }

    @Test
    public void startTagDefinition() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<root>\r\n</ro|ot>";
        XMLDefinitionTest.testDefinitionFor(xml, XMLAssert.ll("test.xml", XMLAssert.r(2, 2, 2, 6), XMLAssert.r(1, 1, 1, 5)));
    }

    @Test
    public void endTagDefinition() throws BadLocationException {
        String xml = "<?xml version='1.0'?>\r\n<roo|t>\r\n</root>";
        XMLDefinitionTest.testDefinitionFor(xml, XMLAssert.ll("test.xml", XMLAssert.r(1, 1, 1, 5), XMLAssert.r(2, 2, 2, 6)));
    }

    private static void testDefinitionFor(String xml, LocationLink ... expectedItems) throws BadLocationException {
        XMLAssert.testDefinitionFor(xml, "test.xml", expectedItems);
    }
}

