/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom.parser;

import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLScannerForExternalDTDTest {
    public Scanner scanner;

    @Test
    public void testDocumentTypeExternalOnly() {
        String dtd = "                \n  <!ENTITY nbsp \"&#xA0;\"> \n  <!ENTITY writer \"Writer: Donald Duck.\">\n";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.Content);
        this.assertOffsetAndToken(19, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(27, TokenType.Whitespace);
        this.assertOffsetAndToken(28, TokenType.DTDEntityName);
        this.assertOffsetAndToken(32, TokenType.Whitespace);
        this.assertOffsetAndToken(33, TokenType.DTDEntityValue);
        this.assertOffsetAndToken(41, TokenType.DTDEndTag);
        this.assertOffsetAndToken(42, TokenType.Content);
        this.assertOffsetAndToken(46, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(54, TokenType.Whitespace);
        this.assertOffsetAndToken(55, TokenType.DTDEntityName);
        this.assertOffsetAndToken(61, TokenType.Whitespace);
        this.assertOffsetAndToken(62, TokenType.DTDEntityValue);
        this.assertOffsetAndToken(84, TokenType.DTDEndTag);
        this.assertOffsetAndToken(85, TokenType.Content);
    }

    @Test
    public void elementDeclWithSeveralBraces() {
        String dtd = "<!ELEMENT error-page ((error-code | exception-type), location)>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(20, TokenType.Whitespace);
        this.assertOffsetAndToken(21, TokenType.DTDStartElementContent);
        this.assertOffsetAndToken(22, TokenType.DTDElementContent);
        this.assertOffsetAndToken(61, TokenType.DTDEndElementContent);
        this.assertOffsetAndToken(62, TokenType.DTDEndTag);
        this.assertOffsetAndToken(63, TokenType.EOS);
    }

    @Test
    public void notationDeclNormal() {
        String dtd = "<!NOTATION png PUBLIC \"JPG 1.0\" \"image/gif\">";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDNotationKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDNotationPublicId);
        this.assertOffsetAndToken(31, TokenType.Whitespace);
        this.assertOffsetAndToken(32, TokenType.DTDNotationSystemId);
        this.assertOffsetAndToken(43, TokenType.DTDEndTag);
        this.assertOffsetAndToken(44, TokenType.EOS);
    }

    @Test
    public void notationDeclMissingSystemId() {
        String dtd = "<!NOTATION png PUBLIC \"JPG 1.0\">";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDNotationKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDNotationPublicId);
        this.assertOffsetAndToken(31, TokenType.DTDEndTag);
        this.assertOffsetAndToken(32, TokenType.EOS);
    }

    @Test
    public void notationDeclMissingKind() {
        String dtd = "<!NOTATION png \"JPG 1.0\" \"image/gif\">";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(36, TokenType.DTDEndTag);
        this.assertOffsetAndToken(37, TokenType.EOS);
    }

    @Test
    public void notationDeclIncorrectURLParameter() {
        String dtd = "<!NOTATION png PUBLIC bad_val >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDNotationKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(30, TokenType.DTDEndTag);
        this.assertOffsetAndToken(31, TokenType.EOS);
    }

    @Test
    public void notationDeclUnclosed() {
        String dtd = "<!NOTATION png PUBLIC bad_val <!ELEMENT>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDNotationKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(30, TokenType.DTDStartElement);
        this.assertOffsetAndToken(39, TokenType.DTDEndTag);
        this.assertOffsetAndToken(40, TokenType.EOS);
    }

    @Test
    public void notationDeclUnclosed2() {
        String dtd = "<!NOTATION png PUBLIC <!ELEMENT>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDNotationKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDStartElement);
        this.assertOffsetAndToken(31, TokenType.DTDEndTag);
        this.assertOffsetAndToken(32, TokenType.EOS);
    }

    @Test
    public void notationDeclUnclosed3() {
        String dtd = "<!NOTATION png <!ELEMENT>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDStartElement);
        this.assertOffsetAndToken(24, TokenType.DTDEndTag);
        this.assertOffsetAndToken(25, TokenType.EOS);
    }

    @Test
    public void notationDeclUnclosed4() {
        String dtd = "<!NOTATION png PUBLIC \"JPG 1.0\" \"image/gif\"<!ELEMENT>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDNotationKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDNotationPublicId);
        this.assertOffsetAndToken(31, TokenType.Whitespace);
        this.assertOffsetAndToken(32, TokenType.DTDNotationSystemId);
        this.assertOffsetAndToken(43, TokenType.DTDStartElement);
        this.assertOffsetAndToken(52, TokenType.DTDEndTag);
        this.assertOffsetAndToken(53, TokenType.EOS);
    }

    @Test
    public void notationDeclNormalMoreSpaces() {
        String dtd = "<!NOTATION png   PUBLIC \"JPG 1.0\"   \"image/gif\" >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDNotationKindPUBLIC);
        this.assertOffsetAndToken(23, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDNotationPublicId);
        this.assertOffsetAndToken(33, TokenType.Whitespace);
        this.assertOffsetAndToken(36, TokenType.DTDNotationSystemId);
        this.assertOffsetAndToken(47, TokenType.Whitespace);
        this.assertOffsetAndToken(48, TokenType.DTDEndTag);
        this.assertOffsetAndToken(49, TokenType.EOS);
    }

    @Test
    public void notationDeclUnrecognizedContent() {
        String dtd = "<!NOTATION png   PUBLIC \"JPG 1.0\"   zz>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDNotationName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDNotationKindPUBLIC);
        this.assertOffsetAndToken(23, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDNotationPublicId);
        this.assertOffsetAndToken(33, TokenType.Whitespace);
        this.assertOffsetAndToken(36, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(38, TokenType.DTDEndTag);
        this.assertOffsetAndToken(39, TokenType.EOS);
    }

    @Test
    public void notationNoParameters() {
        String dtd = "<!NOTATION <!ELEMENT >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartNotation);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDStartElement);
        this.assertOffsetAndToken(20, TokenType.Whitespace);
        this.assertOffsetAndToken(21, TokenType.DTDEndTag);
        this.assertOffsetAndToken(22, TokenType.EOS);
    }

    @Test
    public void elementDeclContent() {
        String dtd = "<!ELEMENT note (to,from,heading,body)>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDStartElementContent);
        this.assertOffsetAndToken(16, TokenType.DTDElementContent);
        this.assertOffsetAndToken(36, TokenType.DTDEndElementContent);
        this.assertOffsetAndToken(37, TokenType.DTDEndTag);
        this.assertOffsetAndToken(38, TokenType.EOS);
    }

    @Test
    public void elementDeclContentWithProlog() {
        String dtd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!ELEMENT note (to,from,heading,body)>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.StartPrologOrPI);
        this.assertOffsetAndToken(2, TokenType.PrologName, "xml");
        this.assertOffsetAndToken(5, TokenType.Whitespace);
        this.assertOffsetAndToken(6, TokenType.AttributeName);
        this.assertOffsetAndToken(13, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(14, TokenType.AttributeValue);
        this.assertOffsetAndToken(19, TokenType.Whitespace);
        this.assertOffsetAndToken(20, TokenType.AttributeName);
        this.assertOffsetAndToken(28, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(29, TokenType.AttributeValue);
        this.assertOffsetAndToken(36, TokenType.PrologEnd);
        this.assertOffsetAndToken(38, TokenType.Content);
        this.assertOffsetAndToken(39, TokenType.DTDStartElement);
        this.assertOffsetAndToken(48, TokenType.Whitespace);
        this.assertOffsetAndToken(49, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(53, TokenType.Whitespace);
        this.assertOffsetAndToken(54, TokenType.DTDStartElementContent);
        this.assertOffsetAndToken(55, TokenType.DTDElementContent);
        this.assertOffsetAndToken(75, TokenType.DTDEndElementContent);
        this.assertOffsetAndToken(76, TokenType.DTDEndTag);
        this.assertOffsetAndToken(77, TokenType.EOS);
    }

    @Test
    public void elementOnlyName() {
        String dtd = "<!ELEMENT note > <!ENTITY>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDEndTag);
        this.assertOffsetAndToken(16, TokenType.Content);
        this.assertOffsetAndToken(17, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(25, TokenType.DTDEndTag);
        this.assertOffsetAndToken(26, TokenType.EOS);
    }

    @Test
    public void elementUnclosed() {
        String dtd = "<!ELEMENT note EMPTY> <!ENTITY>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDElementCategory);
        this.assertOffsetAndToken(20, TokenType.DTDEndTag);
        this.assertOffsetAndToken(21, TokenType.Content);
        this.assertOffsetAndToken(22, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(30, TokenType.DTDEndTag);
        this.assertOffsetAndToken(31, TokenType.EOS);
    }

    @Test
    public void elementDeclCategory() {
        String dtd = "<!ELEMENT note ANY>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDElementCategory);
        this.assertOffsetAndToken(18, TokenType.DTDEndTag);
        this.assertOffsetAndToken(19, TokenType.EOS);
    }

    @Test
    public void elementDeclContentIncomplete() {
        String dtd = "<!ELEMENT note (to,from,heading >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDStartElementContent);
        this.assertOffsetAndToken(16, TokenType.DTDElementContent);
        this.assertOffsetAndToken(32, TokenType.DTDEndTag);
        this.assertOffsetAndToken(33, TokenType.EOS);
    }

    @Test
    public void elementDeclContentIncompleteAndUnclosed() {
        String dtd = "<!ELEMENT note (to,from,heading <!ATTLIST >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDElementDeclName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDStartElementContent);
        this.assertOffsetAndToken(16, TokenType.DTDElementContent);
        this.assertOffsetAndToken(32, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(41, TokenType.Whitespace);
        this.assertOffsetAndToken(42, TokenType.DTDEndTag);
        this.assertOffsetAndToken(43, TokenType.EOS);
    }

    @Test
    public void elementNoParameters() {
        String dtd = "<!ELEMENT   <!ATTLIST >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(12, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDEndTag);
        this.assertOffsetAndToken(23, TokenType.EOS);
    }

    @Test
    public void attlistDecl() {
        String dtd = "<!ATTLIST elName attName CDATA \"defaultVal\">";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(24, TokenType.Whitespace);
        this.assertOffsetAndToken(25, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(30, TokenType.Whitespace);
        this.assertOffsetAndToken(31, TokenType.DTDAttlistAttributeValue);
        this.assertOffsetAndToken(43, TokenType.DTDEndTag);
        this.assertOffsetAndToken(44, TokenType.EOS);
    }

    @Test
    public void attlistDeclWithProlog() {
        String dtd = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!ATTLIST elName attName CDATA \"defaultVal\">";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.StartPrologOrPI);
        this.assertOffsetAndToken(2, TokenType.PrologName, "xml");
        this.assertOffsetAndToken(5, TokenType.Whitespace);
        this.assertOffsetAndToken(6, TokenType.AttributeName);
        this.assertOffsetAndToken(13, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(14, TokenType.AttributeValue);
        this.assertOffsetAndToken(19, TokenType.Whitespace);
        this.assertOffsetAndToken(20, TokenType.AttributeName);
        this.assertOffsetAndToken(28, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(29, TokenType.AttributeValue);
        this.assertOffsetAndToken(36, TokenType.PrologEnd);
        this.assertOffsetAndToken(38, TokenType.Content);
        this.assertOffsetAndToken(39, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(48, TokenType.Whitespace);
        this.assertOffsetAndToken(49, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(55, TokenType.Whitespace);
        this.assertOffsetAndToken(56, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(63, TokenType.Whitespace);
        this.assertOffsetAndToken(64, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(69, TokenType.Whitespace);
        this.assertOffsetAndToken(70, TokenType.DTDAttlistAttributeValue);
        this.assertOffsetAndToken(82, TokenType.DTDEndTag);
        this.assertOffsetAndToken(83, TokenType.EOS);
    }

    @Test
    public void attlistMultipleDecls() {
        String dtd = "<!ATTLIST elName \n    attName1 CDATA \"defaultVal1\"\n    attName2 CDATA \"defaultVal2\">";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(30, TokenType.Whitespace);
        this.assertOffsetAndToken(31, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(36, TokenType.Whitespace);
        this.assertOffsetAndToken(37, TokenType.DTDAttlistAttributeValue);
        this.assertOffsetAndToken(50, TokenType.Whitespace);
        this.assertOffsetAndToken(55, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(63, TokenType.Whitespace);
        this.assertOffsetAndToken(64, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(69, TokenType.Whitespace);
        this.assertOffsetAndToken(70, TokenType.DTDAttlistAttributeValue);
        this.assertOffsetAndToken(83, TokenType.DTDEndTag);
        this.assertOffsetAndToken(84, TokenType.EOS);
    }

    @Test
    public void attlistIncompleteDecl() {
        String dtd = "<!ATTLIST elName \n    attName1 CDATA \n    attName2 CDATA \"defaultVal2\">";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(30, TokenType.Whitespace);
        this.assertOffsetAndToken(31, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(36, TokenType.Whitespace);
        this.assertOffsetAndToken(42, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(70, TokenType.DTDEndTag);
        this.assertOffsetAndToken(71, TokenType.EOS);
    }

    @Test
    public void attlistMissingAttributeName() {
        String dtd = "<!ATTLIST elName CDATA \"value\" >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(22, TokenType.Whitespace);
        this.assertOffsetAndToken(23, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(31, TokenType.DTDEndTag);
        this.assertOffsetAndToken(32, TokenType.EOS);
    }

    @Test
    public void attlistMissingAttributeType() {
        String dtd = "<!ATTLIST elName attName \"value\" >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(24, TokenType.Whitespace);
        this.assertOffsetAndToken(25, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(33, TokenType.DTDEndTag);
        this.assertOffsetAndToken(34, TokenType.EOS);
    }

    @Test
    public void attlistMissingAttributeValue() {
        String dtd = "<!ATTLIST elName attName CDATA >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(24, TokenType.Whitespace);
        this.assertOffsetAndToken(25, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(30, TokenType.Whitespace);
        this.assertOffsetAndToken(31, TokenType.DTDEndTag);
        this.assertOffsetAndToken(32, TokenType.EOS);
    }

    @Test
    public void attlistNoParameters() {
        String dtd = "<!ATTLIST <!ELEMENT >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDStartElement);
        this.assertOffsetAndToken(19, TokenType.Whitespace);
        this.assertOffsetAndToken(20, TokenType.DTDEndTag);
        this.assertOffsetAndToken(21, TokenType.EOS);
    }

    @Test
    public void attlistMissingAttributeNameAndEndBracket() {
        String dtd = "<!ATTLIST elName CDATA \"value\"";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(22, TokenType.Whitespace);
        this.assertOffsetAndToken(23, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(30, TokenType.EOS);
    }

    @Test
    public void attlistDeclMissingEndBracket() {
        String dtd = "<!ATTLIST elName attName CDATA \"defaultVal\" <!ELEMENT>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(10, TokenType.DTDAttlistElementName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDAttlistAttributeName);
        this.assertOffsetAndToken(24, TokenType.Whitespace);
        this.assertOffsetAndToken(25, TokenType.DTDAttlistAttributeType);
        this.assertOffsetAndToken(30, TokenType.Whitespace);
        this.assertOffsetAndToken(31, TokenType.DTDAttlistAttributeValue);
        this.assertOffsetAndToken(43, TokenType.Whitespace);
        this.assertOffsetAndToken(44, TokenType.DTDStartElement);
        this.assertOffsetAndToken(53, TokenType.DTDEndTag);
        this.assertOffsetAndToken(54, TokenType.EOS);
    }

    @Test
    public void entityPUBLIC() {
        String dtd = "<!ENTITY eName PUBLIC \"public/Id\" \"system/Id\" >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDEntityKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDEntityPublicId);
        this.assertOffsetAndToken(33, TokenType.Whitespace);
        this.assertOffsetAndToken(34, TokenType.DTDEntitySystemId);
        this.assertOffsetAndToken(45, TokenType.Whitespace);
        this.assertOffsetAndToken(46, TokenType.DTDEndTag);
        this.assertOffsetAndToken(47, TokenType.EOS);
    }

    @Test
    public void entitySYSTEM() {
        String dtd = "<!ENTITY eName SYSTEM   \"system/Id\" >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDEntityKindSYSTEM);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDEntitySystemId);
        this.assertOffsetAndToken(35, TokenType.Whitespace);
        this.assertOffsetAndToken(36, TokenType.DTDEndTag);
        this.assertOffsetAndToken(37, TokenType.EOS);
    }

    @Test
    public void entityCorrect() {
        String dtd = "<!ENTITY eName \"eValue\" >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDEntityValue);
        this.assertOffsetAndToken(23, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDEndTag);
        this.assertOffsetAndToken(25, TokenType.EOS);
    }

    @Test
    public void entityCorrectWithPercent() {
        String dtd = "<!ENTITY % eName \"eValue\" >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityPercent);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDEntityName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDEntityValue);
        this.assertOffsetAndToken(25, TokenType.Whitespace);
        this.assertOffsetAndToken(26, TokenType.DTDEndTag);
        this.assertOffsetAndToken(27, TokenType.EOS);
    }

    @Test
    public void entityCorrectWithPercentAndPublic() {
        String dtd = "<!ENTITY % eName PUBLIC \"publicId\" \"systemId\" >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityPercent);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDEntityName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDEntityKindPUBLIC);
        this.assertOffsetAndToken(23, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDEntityPublicId);
        this.assertOffsetAndToken(34, TokenType.Whitespace);
        this.assertOffsetAndToken(35, TokenType.DTDEntitySystemId);
        this.assertOffsetAndToken(45, TokenType.Whitespace);
        this.assertOffsetAndToken(46, TokenType.DTDEndTag);
        this.assertOffsetAndToken(47, TokenType.EOS);
    }

    @Test
    public void entityIncorrectWithPercentAndPublic() {
        String dtd = "<!ENTITY % eName PUBLIC \"publicId\" \"systemId\" garbage>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityPercent);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.DTDEntityName);
        this.assertOffsetAndToken(16, TokenType.Whitespace);
        this.assertOffsetAndToken(17, TokenType.DTDEntityKindPUBLIC);
        this.assertOffsetAndToken(23, TokenType.Whitespace);
        this.assertOffsetAndToken(24, TokenType.DTDEntityPublicId);
        this.assertOffsetAndToken(34, TokenType.Whitespace);
        this.assertOffsetAndToken(35, TokenType.DTDEntitySystemId);
        this.assertOffsetAndToken(45, TokenType.Whitespace);
        this.assertOffsetAndToken(46, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(53, TokenType.DTDEndTag);
        this.assertOffsetAndToken(54, TokenType.EOS);
    }

    @Test
    public void entityIncorrectMissingSystemId() {
        String dtd = "<!ENTITY eName PUBLIC \"publicId\" aa>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDEntityKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDEntityPublicId);
        this.assertOffsetAndToken(32, TokenType.Whitespace);
        this.assertOffsetAndToken(33, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(35, TokenType.DTDEndTag);
        this.assertOffsetAndToken(36, TokenType.EOS);
    }

    @Test
    public void entityIncorrectMissingSystemIdUnclosed() {
        String dtd = "<!ENTITY eName PUBLIC \"publicId\" <!ELEMENT>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDEntityKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDEntityPublicId);
        this.assertOffsetAndToken(32, TokenType.Whitespace);
        this.assertOffsetAndToken(33, TokenType.DTDStartElement);
        this.assertOffsetAndToken(42, TokenType.DTDEndTag);
        this.assertOffsetAndToken(43, TokenType.EOS);
    }

    @Test
    public void entityIncorrectMissingIDs() {
        String dtd = "<!ENTITY eName PUBLIC aa>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDEntityKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(24, TokenType.DTDEndTag);
        this.assertOffsetAndToken(25, TokenType.EOS);
    }

    @Test
    public void entityIncorrect() {
        String dtd = "<!ENTITY eName PUBLIC aa <!ATTLIST>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DTDEntityName);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.DTDEntityKindPUBLIC);
        this.assertOffsetAndToken(21, TokenType.Whitespace);
        this.assertOffsetAndToken(22, TokenType.DTDUnrecognizedParameters);
        this.assertOffsetAndToken(25, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(34, TokenType.DTDEndTag);
        this.assertOffsetAndToken(35, TokenType.EOS);
    }

    @Test
    public void dtdUnrecognizedTagName() {
        String dtd = "<!BAD eName aaa \"asdasd\">";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.Content);
        this.assertOffsetAndToken(25, TokenType.EOS);
    }

    @Test
    public void dtdUnrecognizedTagName2() {
        String dtd = "<!BAD eName aaa \"asdasd\"> <!ELEMENT >";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.Content);
        this.assertOffsetAndToken(25, TokenType.Content);
        this.assertOffsetAndToken(26, TokenType.DTDStartElement);
        this.assertOffsetAndToken(35, TokenType.Whitespace);
        this.assertOffsetAndToken(36, TokenType.DTDEndTag);
        this.assertOffsetAndToken(37, TokenType.EOS);
    }

    @Test
    public void dtdUnrecognizedContent() {
        String dtd = "<!ELEMENT>    aaa gf  <!ATTLIST>";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.DTDStartElement);
        this.assertOffsetAndToken(9, TokenType.DTDEndTag);
        this.assertOffsetAndToken(10, TokenType.Content);
        this.assertOffsetAndToken(22, TokenType.DTDStartAttlist);
        this.assertOffsetAndToken(31, TokenType.DTDEndTag);
        this.assertOffsetAndToken(32, TokenType.EOS);
    }

    @Test
    public void dtdUnrecognizedContent2() {
        String dtd = "<![ %HTML.Reserved; [\r\n<!ENTITY % reserved\r\n \"datasrc     %URI;          #IMPLIED  -- \"\r\n  >\r\n]]>\r\n\r\n<!--=================== Text Markup ======================================-->";
        this.scanner = XMLScanner.createScanner((String)dtd, (boolean)true);
        this.assertOffsetAndToken(0, TokenType.Content);
        this.assertOffsetAndToken(23, TokenType.DTDStartEntity);
        this.assertOffsetAndToken(31, TokenType.Whitespace);
        this.assertOffsetAndToken(32, TokenType.DTDEntityPercent);
        this.assertOffsetAndToken(33, TokenType.Whitespace);
        this.assertOffsetAndToken(34, TokenType.DTDEntityName);
        this.assertOffsetAndToken(42, TokenType.Whitespace);
        this.assertOffsetAndToken(45, TokenType.DTDEntityValue);
        this.assertOffsetAndToken(87, TokenType.Whitespace);
        this.assertOffsetAndToken(91, TokenType.DTDEndTag);
        this.assertOffsetAndToken(92, TokenType.Content);
        this.assertOffsetAndToken(101, TokenType.StartCommentTag);
        this.assertOffsetAndToken(105, TokenType.Comment);
        this.assertOffsetAndToken(175, TokenType.EndCommentTag);
        this.assertOffsetAndToken(178, TokenType.EOS);
    }

    public void assertOffsetAndToken(int tokenOffset, TokenType tokenType) {
        TokenType token = this.scanner.scan();
        Assertions.assertEquals((int)tokenOffset, (int)this.scanner.getTokenOffset());
        Assertions.assertEquals((Object)tokenType, (Object)token);
    }

    public void assertOffsetAndToken(int tokenOffset, TokenType tokenType, String tokenText) {
        TokenType token = this.scanner.scan();
        Assertions.assertEquals((int)tokenOffset, (int)this.scanner.getTokenOffset());
        Assertions.assertEquals((Object)tokenType, (Object)token);
        Assertions.assertEquals((Object)tokenText, (Object)this.scanner.getTokenText());
    }
}

