/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLDiagnostics {
    private static Logger LOGGER = Logger.getLogger(XMLDiagnostics.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLDiagnostics(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<Diagnostic> doDiagnostics(DOMDocument xmlDocument, CancelChecker monitor, XMLValidationSettings validationSettings) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (validationSettings == null || validationSettings.isEnabled()) {
            try {
                this.doBasicDiagnostics(xmlDocument, diagnostics, monitor);
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.WARNING, "BadLocationException thrown doing doBasicDiagnostics() in XMLDiagnostics.", e);
            }
            this.doExtensionsDiagnostics(xmlDocument, diagnostics, monitor);
        }
        return diagnostics;
    }

    private void doBasicDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, CancelChecker monitor) throws BadLocationException {
    }

    private void doExtensionsDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, CancelChecker monitor) {
        for (IDiagnosticsParticipant diagnosticsParticipant : this.extensionsRegistry.getDiagnosticsParticipants()) {
            monitor.checkCanceled();
            diagnosticsParticipant.doDiagnostics(xmlDocument, diagnostics, monitor);
        }
    }
}

