/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lemminx.client.InvalidPathWarner;
import org.eclipse.lemminx.client.PathFeature;
import org.eclipse.lemminx.extensions.catalog.XMLCatalogURIResolverExtension;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.services.IXMLNotificationService;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.InitializeParams;

public class XMLCatalogPlugin
implements IXMLExtension {
    private XMLCatalogURIResolverExtension uiResolver;
    private InvalidPathWarner pathWarner;

    @Override
    public void doSave(ISaveContext context) {
        Object initializationOptionsSettings = context.getSettings();
        ContentModelSettings cmSettings = ContentModelSettings.getContentModelXMLSettings(initializationOptionsSettings);
        if (cmSettings == null) {
            return;
        }
        this.validateCatalogPaths(cmSettings);
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        this.uiResolver = new XMLCatalogURIResolverExtension(registry);
        registry.getResolverExtensionManager().registerResolver(this.uiResolver);
        IXMLNotificationService notificationService = registry.getNotificationService();
        if (notificationService != null) {
            this.pathWarner = new InvalidPathWarner(notificationService);
        }
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.getResolverExtensionManager().unregisterResolver(this.uiResolver);
    }

    private void validateCatalogPaths(ContentModelSettings cmSettings) {
        if (this.pathWarner == null) {
            return;
        }
        String[] catalogs = cmSettings.getCatalogs();
        Set<String> invalidCatalogs = Arrays.stream(catalogs).filter(c -> !XMLCatalogPlugin.isXMLCatalogFileValid(c)).collect(Collectors.toSet());
        if (invalidCatalogs.size() > 0) {
            this.pathWarner.onInvalidFilePath(invalidCatalogs, PathFeature.CATALOGS);
        } else {
            this.pathWarner.evictKey(PathFeature.CATALOGS);
        }
    }

    private static boolean isXMLCatalogFileValid(String catalogFile) {
        try {
            return new File(new URI(catalogFile).toString()).exists();
        }
        catch (URISyntaxException e) {
            return new File(catalogFile).exists();
        }
    }
}

