/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.logs;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.lemminx.logs.LSPClientLogHandler;
import org.eclipse.lemminx.settings.LogsSettings;
import org.eclipse.lsp4j.services.LanguageClient;

public class LogHelper {
    public static void initializeRootLogger(LanguageClient newLanguageClient, LogsSettings settings) {
        String path;
        if (newLanguageClient == null || settings == null) {
            return;
        }
        Logger logger = Logger.getLogger("");
        LogHelper.unregisterAllHandlers(logger.getHandlers());
        logger.setLevel(LogHelper.getLogLevel());
        logger.setUseParentHandlers(false);
        if (settings.getClient()) {
            try {
                logger.addHandler(LogHelper.getClientHandler(newLanguageClient));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((path = settings.getFile()) != null) {
            LogHelper.createDirectoryPath(path);
            try {
                FileHandler fh = LogHelper.getFileHandler(path);
                logger.addHandler(fh);
            }
            catch (IOException | SecurityException e) {
                logger.warning("Error at creation of FileHandler for logging");
            }
        } else {
            logger.info("Log file could not be created, path not provided");
        }
    }

    private static Level getLogLevel() {
        String logLevel;
        switch (logLevel = System.getProperty("log.level", "info").toLowerCase()) {
            case "info": {
                return Level.INFO;
            }
            case "off": {
                return Level.OFF;
            }
            case "all": 
            case "debug": 
            case "fine": 
            case "finer": 
            case "finest": {
                return Level.FINEST;
            }
            case "warn": 
            case "warning": {
                return Level.WARNING;
            }
            case "error": 
            case "fatal": {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }

    private static void createDirectoryPath(String path) {
        Path parentPath = Paths.get(path, new String[0]).normalize().getParent();
        if (parentPath != null) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static LSPClientLogHandler getClientHandler(LanguageClient languageClient) {
        if (languageClient == null) {
            return null;
        }
        return new LSPClientLogHandler(languageClient);
    }

    public static FileHandler getFileHandler(String filePath) throws SecurityException, IOException {
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("Incorrect file path provided");
        }
        File f = new File(filePath);
        if (f.isDirectory()) {
            throw new IllegalArgumentException("Provided path was a directory");
        }
        if (!f.exists() || f.canWrite()) {
            FileHandler fh = null;
            fh = new FileHandler(filePath, true);
            fh.setFormatter(new SimpleFormatter());
            fh.setLevel(Level.INFO);
            return fh;
        }
        throw new IOException("Cannot write file since it cannot be written to");
    }

    public static void unregisterHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        handler.close();
        Logger.getLogger("").removeHandler(handler);
    }

    public static void unregisterAllHandlers(Handler[] handlers) {
        if (handlers == null) {
            return;
        }
        for (Handler h : handlers) {
            LogHelper.unregisterHandler(h);
        }
    }
}

