/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.model;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilesChangedTracker {
    private static final Logger LOGGER = Logger.getLogger(FilesChangedTracker.class.getName());
    private final List<FileChangedTracker> files = new ArrayList<FileChangedTracker>();

    public void addFileURI(String fileURI) {
        try {
            this.files.add(new FileChangedTracker(Paths.get(new URI(fileURI))));
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, "Add file URI to track failed", e);
        }
    }

    public boolean isDirty() {
        for (FileChangedTracker dirtyFile : this.files) {
            if (!dirtyFile.isDirty()) continue;
            return true;
        }
        return false;
    }

    private static class FileChangedTracker {
        private final Path file;
        private FileTime lastModified;

        public FileChangedTracker(Path file) {
            this.file = file;
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    this.lastModified = Files.getLastModifiedTime(file, new LinkOption[0]);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Get last modified time failed", e);
                }
            }
        }

        public boolean isDirty() {
            try {
                if (!Files.exists(this.file, new LinkOption[0])) {
                    return true;
                }
                FileTime currentLastModified = Files.getLastModifiedTime(this.file, new LinkOption[0]);
                if (!currentLastModified.equals(this.lastModified)) {
                    this.lastModified = currentLastModified;
                    return true;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Get last modified time failed", e);
                return true;
            }
            return false;
        }
    }
}

