/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.participants;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.extensions.dtd.utils.DTDUtils;
import org.eclipse.lemminx.services.extensions.AbstractDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IDefinitionRequest;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class DTDDefinitionParticipant
extends AbstractDefinitionParticipant {
    @Override
    protected boolean match(DOMDocument document) {
        return !DOMUtils.isXSD(document);
    }

    @Override
    protected void doFindDefinition(IDefinitionRequest request, List<LocationLink> locations, CancelChecker cancelChecker) {
        DOMNode node = request.getNode();
        int offset = request.getOffset();
        if (!node.isDTDElementDecl() && !node.isDTDAttListDecl()) {
            return;
        }
        DTDDeclParameter originName = ((DTDDeclNode)node).getReferencedElementNameAt(offset);
        if (originName != null) {
            DTDUtils.searchDTDTargetElementDecl(originName, true, targetElementName -> {
                LocationLink location = XMLPositionUtility.createLocationLink(originName, targetElementName);
                locations.add(location);
            });
        }
    }
}

