/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.contentmodel;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLDTDLoader;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.FilesChangedTracker;
import org.eclipse.lemminx.extensions.dtd.contentmodel.CMDTDAttributeDeclaration;
import org.eclipse.lemminx.extensions.dtd.contentmodel.CMDTDElementDeclaration;
import org.eclipse.lemminx.extensions.dtd.utils.DTDUtils;
import org.eclipse.lsp4j.LocationLink;

public class CMDTDDocument
extends XMLDTDLoader
implements CMDocument {
    private final String uri;
    private Map<String, DTDElementInfo> hierarchiesMap;
    private List<CMElementDeclaration> elements;
    private DTDGrammar grammar;
    private Set<String> hierarchies;
    private FilesChangedTracker tracker;
    private String comment;
    private DTDElementInfo dtdElementInfo;
    private Map<String, DTDNodeInfo> attributes;
    private DTDNodeInfo nodeInfo;

    public CMDTDDocument() {
        this(null);
    }

    public CMDTDDocument(String uri) {
        this.uri = uri;
    }

    @Override
    public boolean hasNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public Collection<CMElementDeclaration> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<CMElementDeclaration>();
            int index = this.grammar.getFirstElementDeclIndex();
            while (index != -1) {
                CMDTDElementDeclaration elementDecl = new CMDTDElementDeclaration(this, index);
                this.grammar.getElementDecl(index, (XMLElementDecl)elementDecl);
                this.elements.add(elementDecl);
                index = this.grammar.getNextElementDeclIndex(index);
            }
        }
        return this.elements;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public CMElementDeclaration findCMElement(DOMElement element, String namespace) {
        ArrayList<DOMElement> paths = new ArrayList<DOMElement>();
        while (element != null && (namespace == null || namespace.equals(element.getNamespaceURI()))) {
            paths.add(0, element);
            element = element.getParentNode() instanceof DOMElement ? (DOMElement)element.getParentNode() : null;
        }
        CMElementDeclaration declaration = null;
        for (int i = 0; i < paths.size(); ++i) {
            DOMElement elt = (DOMElement)paths.get(i);
            declaration = i == 0 ? this.findElementDeclaration(elt.getLocalName(), namespace) : declaration.findCMElement(elt.getLocalName(), namespace);
            if (declaration == null) break;
        }
        return declaration;
    }

    private CMElementDeclaration findElementDeclaration(String tag, String namespace) {
        for (CMElementDeclaration cmElement : this.getElements()) {
            if (!cmElement.getName().equals(tag)) continue;
            return cmElement;
        }
        return null;
    }

    public void startContentModel(String elementName, Augmentations augs) throws XNIException {
        if (this.hierarchiesMap == null) {
            this.hierarchiesMap = new HashMap<String, DTDElementInfo>();
        }
        this.dtdElementInfo = new DTDElementInfo();
        if (this.comment != null) {
            this.dtdElementInfo.setComment(this.comment);
        }
        this.hierarchiesMap.put(elementName, this.dtdElementInfo);
        super.startContentModel(elementName, augs);
    }

    public void element(String elementName, Augmentations augs) throws XNIException {
        this.hierarchies = this.dtdElementInfo.getHierarchies();
        this.hierarchies.add(elementName);
        super.element(elementName, augs);
    }

    public void endContentModel(Augmentations augs) throws XNIException {
        this.comment = null;
        this.hierarchies = null;
        super.endContentModel(augs);
    }

    public void startAttlist(String elementName, Augmentations augs) throws XNIException {
        this.attributes = this.dtdElementInfo.getAttributes();
        super.startAttlist(elementName, augs);
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augs) throws XNIException {
        if (this.comment != null) {
            this.nodeInfo = new DTDNodeInfo();
            this.nodeInfo.setComment(this.comment);
            this.attributes.put(attributeName, this.nodeInfo);
        }
        super.attributeDecl(elementName, attributeName, type, enumeration, defaultType, defaultValue, nonNormalizedDefaultValue, augs);
    }

    public void endAttlist(Augmentations augs) throws XNIException {
        this.comment = null;
        this.attributes = null;
        this.nodeInfo = null;
        super.endAttlist(augs);
    }

    public Grammar loadGrammar(XMLInputSource source) throws IOException, XNIException {
        this.grammar = (DTDGrammar)super.loadGrammar(source);
        this.tracker = DTDUtils.createFilesChangedTracker(this.grammar);
        return this.grammar;
    }

    public void loadInternalDTD(String internalSubset, String baseSystemId, String systemId) throws XNIException, IOException {
        XMLInputSource source = new XMLInputSource("", "", "", (Reader)new StringReader(""), "");
        this.grammar = (DTDGrammar)this.loadGrammar(source);
        this.fDTDScanner.reset();
        StringBuilder buffer = new StringBuilder(internalSubset.length() + 2);
        buffer.append(internalSubset).append("]>");
        XMLInputSource is = new XMLInputSource(null, baseSystemId, null, (Reader)new StringReader(buffer.toString()), null);
        this.fEntityManager.startDocumentEntity(is);
        this.fDTDScanner.scanDTDInternalSubset(true, false, systemId != null);
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (text != null) {
            this.comment = text.toString();
        }
        super.comment(text, augs);
    }

    public Map<String, DTDElementInfo> getHierarchiesMap() {
        return this.hierarchiesMap;
    }

    void collectElementsDeclaration(String elementName, List<CMElementDeclaration> elements) {
        if (this.hierarchiesMap == null) {
            return;
        }
        DTDElementInfo elementInfo = this.hierarchiesMap.get(elementName);
        Set<String> children = elementInfo.getHierarchies();
        if (children == null) {
            return;
        }
        children.stream().forEach(name -> {
            CMElementDeclaration element = this.findElementDeclaration((String)name, null);
            if (element != null) {
                elements.add(element);
            }
        });
    }

    void collectAttributesDeclaration(CMDTDElementDeclaration elementDecl, List<CMAttributeDeclaration> attributes) {
        int elementDeclIndex = this.grammar.getElementDeclIndex(elementDecl.name);
        int index = this.grammar.getFirstAttributeDeclIndex(elementDeclIndex);
        while (index != -1) {
            CMDTDAttributeDeclaration attributeDecl = new CMDTDAttributeDeclaration(elementDecl);
            this.grammar.getAttributeDecl(index, (XMLAttributeDecl)attributeDecl);
            attributes.add(attributeDecl);
            index = this.grammar.getNextAttributeDeclIndex(index);
        }
    }

    @Override
    public LocationLink findTypeLocation(DOMNode node) {
        return null;
    }

    @Override
    public boolean isDirty() {
        return this.tracker != null ? Boolean.valueOf(this.tracker.isDirty()) : null;
    }

    static class DTDElementInfo
    extends DTDNodeInfo {
        private final Set<String> hierarchies = new LinkedHashSet<String>();
        private final Map<String, DTDNodeInfo> attributes = new HashMap<String, DTDNodeInfo>();

        public Set<String> getHierarchies() {
            return this.hierarchies;
        }

        public Map<String, DTDNodeInfo> getAttributes() {
            return this.attributes;
        }

        public String getComment(String attrName) {
            DTDNodeInfo attr = this.attributes.get(attrName);
            return attr != null ? attr.getComment() : null;
        }
    }

    static class DTDNodeInfo {
        private String comment = null;

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

