/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.contentmodel;

import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.extensions.dtd.contentmodel.CMDTDDocument;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;

public class CMDTDContentModelProvider
implements ContentModelProvider {
    private final URIResolverExtensionManager resolverExtensionManager;

    public CMDTDContentModelProvider(URIResolverExtensionManager resolverExtensionManager) {
        this.resolverExtensionManager = resolverExtensionManager;
    }

    @Override
    public boolean adaptFor(DOMDocument document, boolean internal) {
        if (internal) {
            DOMDocumentType documentType = document.getDoctype();
            return documentType != null && !StringUtils.isEmpty(documentType.getInternalSubset());
        }
        return document.hasDTD();
    }

    @Override
    public boolean adaptFor(String uri) {
        return DOMUtils.isDTD(uri);
    }

    @Override
    public String getSystemId(DOMDocument xmlDocument, String namespaceURI) {
        DOMDocumentType documentType = xmlDocument.getDoctype();
        return documentType.getSystemIdWithoutQuotes();
    }

    @Override
    public CMDocument createCMDocument(String key) {
        try {
            CMDTDDocument document = new CMDTDDocument(key);
            document.setEntityResolver(this.resolverExtensionManager);
            Grammar grammar = document.loadGrammar(new XMLInputSource(null, key, null));
            if (grammar != null) {
                return document;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    @Override
    public CMDocument createInternalCMDocument(DOMDocument xmlDocument) {
        try {
            CMDTDDocument document = new CMDTDDocument();
            document.setEntityResolver(this.resolverExtensionManager);
            DOMDocumentType documentType = xmlDocument.getDoctype();
            String internalSubset = documentType.getInternalSubset();
            String baseSystemId = null;
            String systemId = null;
            document.loadInternalDTD(internalSubset, baseSystemId, systemId);
            return document;
        }
        catch (Exception e) {
            return null;
        }
    }
}

