/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.extensions.contentmodel.uriresolver.XMLCacheResolverExtension;
import org.eclipse.lemminx.extensions.contentmodel.uriresolver.XMLCatalogResolverExtension;
import org.eclipse.lemminx.extensions.contentmodel.uriresolver.XMLFileAssociationResolverExtension;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.URIUtils;

public class ContentModelManager {
    private final Map<String, CMDocument> cmDocumentCache;
    private final URIResolverExtensionManager resolverManager;
    private final List<ContentModelProvider> modelProviders;
    private final XMLCacheResolverExtension cacheResolverExtension;
    private final XMLCatalogResolverExtension catalogResolverExtension;
    private final XMLFileAssociationResolverExtension fileAssociationResolver;
    private final XMLGrammarPool grammarPool;

    public ContentModelManager(URIResolverExtensionManager resolverManager) {
        this.resolverManager = resolverManager;
        this.modelProviders = new ArrayList<ContentModelProvider>();
        this.cmDocumentCache = Collections.synchronizedMap(new HashMap());
        this.fileAssociationResolver = new XMLFileAssociationResolverExtension();
        resolverManager.registerResolver(this.fileAssociationResolver);
        this.catalogResolverExtension = new XMLCatalogResolverExtension();
        resolverManager.registerResolver(this.catalogResolverExtension);
        this.cacheResolverExtension = new XMLCacheResolverExtension();
        resolverManager.registerResolver(this.cacheResolverExtension);
        this.grammarPool = new LSPXMLGrammarPool();
        this.setUseCache(true);
    }

    public CMElementDeclaration findCMElement(DOMElement element) throws Exception {
        return this.findCMElement(element, element.getNamespaceURI());
    }

    public CMElementDeclaration findCMElement(DOMElement element, String namespaceURI) throws Exception {
        CMDocument cmDocument = this.findCMDocument(element, namespaceURI);
        return cmDocument != null ? cmDocument.findCMElement(element, namespaceURI) : null;
    }

    public CMDocument findCMDocument(DOMElement element, String namespaceURI) {
        return this.findCMDocument(element.getOwnerDocument(), namespaceURI);
    }

    public CMDocument findCMDocument(DOMDocument xmlDocument, String namespaceURI) {
        ContentModelProvider modelProvider = this.getModelProviderByStandardAssociation(xmlDocument, false);
        String systemId = modelProvider != null ? modelProvider.getSystemId(xmlDocument, namespaceURI) : null;
        return this.findCMDocument(xmlDocument.getDocumentURI(), namespaceURI, systemId, modelProvider);
    }

    public boolean dependsOnGrammar(DOMDocument document, String grammarURI) {
        if (StringUtils.isEmpty(grammarURI)) {
            return false;
        }
        ContentModelProvider modelProvider = this.getModelProviderByStandardAssociation(document, false);
        String systemId = modelProvider != null ? modelProvider.getSystemId(document, document.getNamespaceURI()) : null;
        String key = this.resolverManager.resolve(document.getDocumentURI(), null, systemId);
        return grammarURI.equals(key);
    }

    /*
     * Unable to fully structure code
     */
    private CMDocument findCMDocument(String uri, String publicId, String systemId, ContentModelProvider modelProvider) {
        resolvedUri = this.resolverManager.resolve(uri, publicId, systemId);
        if (resolvedUri == null) {
            return null;
        }
        if (modelProvider == null) {
            modelProvider = this.getModelProviderByURI(resolvedUri);
        }
        if (modelProvider == null) {
            return null;
        }
        cmDocument = this.getCMDocumentFromCache(resolvedUri);
        if (cmDocument != null) {
            return cmDocument;
        }
        isFileResource = URIUtils.isFileResource(resolvedUri);
        if (!isFileResource && this.cacheResolverExtension.isUseCache()) {
            try {
                file = this.cacheResolverExtension.getCachedResource(resolvedUri);
                if (file == null) ** GOTO lbl24
                cmDocument = modelProvider.createCMDocument(file.toFile().getPath());
            }
            catch (CacheResourceDownloadingException e) {
                return null;
            }
            catch (Exception e) {
                cmDocument = modelProvider.createCMDocument(resolvedUri);
            }
        } else {
            cmDocument = modelProvider.createCMDocument(resolvedUri);
        }
lbl24:
        // 4 sources

        if (cmDocument != null) {
            this.cache(resolvedUri, cmDocument);
        }
        return cmDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMDocument getCMDocumentFromCache(String key) {
        CMDocument document = null;
        Map<String, CMDocument> map = this.cmDocumentCache;
        synchronized (map) {
            document = this.cmDocumentCache.get(key);
            if (document != null && document.isDirty()) {
                this.cmDocumentCache.remove(key);
                return null;
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(String key, CMDocument cmDocument) {
        Map<String, CMDocument> map = this.cmDocumentCache;
        synchronized (map) {
            this.cmDocumentCache.put(key, cmDocument);
        }
    }

    public CMElementDeclaration findInternalCMElement(DOMElement element) throws Exception {
        return this.findInternalCMElement(element, element.getNamespaceURI());
    }

    public CMElementDeclaration findInternalCMElement(DOMElement element, String namespaceURI) throws Exception {
        CMDocument cmDocument = this.findInternalCMDocument(element, namespaceURI);
        return cmDocument != null ? cmDocument.findCMElement(element, namespaceURI) : null;
    }

    public CMDocument findInternalCMDocument(DOMElement element, String namespaceURI) {
        return this.findInternalCMDocument(element.getOwnerDocument(), namespaceURI);
    }

    public CMDocument findInternalCMDocument(DOMDocument xmlDocument, String namespaceURI) {
        ContentModelProvider modelProvider = this.getModelProviderByStandardAssociation(xmlDocument, true);
        if (modelProvider != null) {
            return modelProvider.createInternalCMDocument(xmlDocument);
        }
        return null;
    }

    private ContentModelProvider getModelProviderByStandardAssociation(DOMDocument xmlDocument, boolean internal) {
        for (ContentModelProvider modelProvider : this.modelProviders) {
            if (!modelProvider.adaptFor(xmlDocument, internal)) continue;
            return modelProvider;
        }
        return null;
    }

    private ContentModelProvider getModelProviderByURI(String uri) {
        for (ContentModelProvider modelProvider : this.modelProviders) {
            if (!modelProvider.adaptFor(uri)) continue;
            return modelProvider;
        }
        return null;
    }

    public boolean setCatalogs(String[] catalogs) {
        return this.catalogResolverExtension.setCatalogs(catalogs);
    }

    public void refreshCatalogs() {
        this.catalogResolverExtension.refreshCatalogs();
    }

    public boolean setFileAssociations(XMLFileAssociation[] fileAssociations) {
        return this.fileAssociationResolver.setFileAssociations(fileAssociations);
    }

    public void setRootURI(String rootUri) {
        rootUri = URIUtils.sanitizingUri(rootUri);
        this.fileAssociationResolver.setRootUri(rootUri);
        this.catalogResolverExtension.setRootUri(rootUri);
    }

    public void setUseCache(boolean useCache) {
        this.cacheResolverExtension.setUseCache(useCache);
        if (!useCache) {
            this.grammarPool.clear();
        }
    }

    public void registerModelProvider(ContentModelProvider modelProvider) {
        this.modelProviders.add(modelProvider);
    }

    public void unregisterModelProvider(ContentModelProvider modelProvider) {
        this.modelProviders.remove(modelProvider);
    }

    public XMLGrammarPool getGrammarPool() {
        return this.cacheResolverExtension.isUseCache() ? this.grammarPool : null;
    }
}

