/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.kura.util.osgi.FilterUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class BundleUtil {
    private BundleUtil() {
    }

    public static Set<Bundle> getBundles(BundleContext bundleContext, Class<?>[] classes, Map<String, String> properties) {
        Objects.requireNonNull(bundleContext, "Bundle context cannot be null.");
        Objects.requireNonNull(properties, "Filter cannot be null.");
        Objects.requireNonNull(classes, "Class array cannot be null.");
        String classFilter = Arrays.stream(classes).map(FilterUtil::objectClass).reduce("", (string, string2) -> FilterUtil.or(string, string2));
        String propertiesFilter = properties.entrySet().stream().map(p -> FilterUtil.equal((String)p.getKey(), (String)p.getValue())).reduce("", (string, string2) -> FilterUtil.and(string, string2));
        String filterAsString = FilterUtil.and(classFilter, propertiesFilter);
        try {
            Filter filter = bundleContext.createFilter(filterAsString);
            ServiceReference[] services = bundleContext.getAllServiceReferences(null, filter.toString());
            if (services == null || services.length == 0) {
                return Collections.emptySet();
            }
            return Arrays.stream(services).map(ServiceReference::getBundle).collect(Collectors.toSet());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Set<Bundle> getBundles(BundleContext bundleContext, Map<String, String> headers) {
        Objects.requireNonNull(bundleContext, "Bundle context cannot be null.");
        Objects.requireNonNull(headers, "Properties cannot be null.");
        return Stream.of(bundleContext.getBundles()).filter(BundleUtil.contains(headers)).collect(Collectors.toSet());
    }

    private static Predicate<? super Bundle> contains(Map<String, String> properties) {
        return b -> {
            Dictionary headers = b.getHeaders();
            Map headersMap = Collections.list(headers.keys()).stream().collect(Collectors.toMap(Function.identity(), headers::get));
            return headersMap.entrySet().containsAll(properties.entrySet());
        };
    }
}

