/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.Set;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtUserService;

public class GwtUserServiceImpl
extends OsgiRemoteServiceServlet
implements GwtUserService {
    private static final long serialVersionUID = 6065248347373180366L;
    private final UserManager userManager;

    public GwtUserServiceImpl(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public void createUser(GwtXSRFToken token, String userName) throws GwtKuraException {
        this.checkXSRFToken(token);
        this.userManager.createUser(userName);
    }

    @Override
    public void deleteUser(GwtXSRFToken token, String userName) throws GwtKuraException {
        this.checkXSRFToken(token);
        this.userManager.deleteUser(userName);
    }

    @Override
    public Set<String> getDefinedPermissions(GwtXSRFToken token) throws GwtKuraException {
        this.checkXSRFToken(token);
        return this.userManager.getDefinedPermissions();
    }

    @Override
    public Set<GwtUserConfig> getUserConfig(GwtXSRFToken token) throws GwtKuraException {
        this.checkXSRFToken(token);
        return this.userManager.getUserConfig();
    }

    @Override
    public GwtUserConfig getUserConfigOrDefault(GwtXSRFToken token, String name) throws GwtKuraException {
        this.checkXSRFToken(token);
        return this.userManager.getUserDefaultConfig(name);
    }

    @Override
    public void setUserConfig(GwtXSRFToken token, Set<GwtUserConfig> userConfig) throws GwtKuraException {
        this.checkXSRFToken(token);
        this.userManager.setUserConfig(userConfig);
    }
}

