/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.configuration.api;

import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.rest.configuration.api.FailureHandler;
import org.eclipse.kura.rest.configuration.api.PropertyDTO;
import org.eclipse.kura.rest.configuration.api.Validable;

public class FactoryComponentConfigurationDTO
implements Validable {
    private final String factoryPid;
    private final String pid;
    private final Map<String, PropertyDTO> properties;

    public FactoryComponentConfigurationDTO(String factoryPid, String pid, Map<String, PropertyDTO> properties) {
        this.factoryPid = factoryPid;
        this.pid = pid;
        this.properties = properties;
    }

    public String getFactoryPid() {
        return this.factoryPid;
    }

    public String getPid() {
        return this.pid;
    }

    public Map<String, PropertyDTO> getProperties() {
        return this.properties != null ? this.properties : Collections.emptyMap();
    }

    @Override
    public void validate() {
        FailureHandler.requireParameter(this.factoryPid, "factoryPid");
        FailureHandler.requireParameter(this.pid, "pid");
        if (this.properties != null) {
            for (PropertyDTO param : this.properties.values()) {
                if (param == null) {
                    throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)"propety values cannot be null");
                }
                param.validate();
            }
        }
    }
}

