/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.certificate.CertificatesService;
import org.eclipse.kura.certificate.KuraCertificateEntry;
import org.eclipse.kura.core.keystore.util.KeystoreRemoteService;
import org.eclipse.kura.security.keystore.KeystoreService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtKeystoreEntry;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtCertificatesService;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtCertificatesServiceImpl
extends OsgiRemoteServiceServlet
implements GwtCertificatesService {
    private static final long serialVersionUID = 7402961266449489433L;
    private static final String KURA_SERVICE_PID = "kura.service.pid";
    private static final Logger logger = LoggerFactory.getLogger(GwtCertificatesServiceImpl.class);

    @Override
    public void storeKeyPair(GwtXSRFToken xsrfToken, String keyStorePid, String privateKey, String publicCert, String alias) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            KeyStore.PrivateKeyEntry entry = KeystoreRemoteService.createPrivateKey((String)privateKey, (String)publicCert);
            if (entry == null) {
                throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
            }
            String filter = String.format("(%s=%s)", KURA_SERVICE_PID, keyStorePid);
            Collection<ServiceReference<KeystoreService>> keystoreServiceReferences = ServiceLocator.getInstance().getServiceReferences(KeystoreService.class, filter);
            for (ServiceReference<KeystoreService> reference : keystoreServiceReferences) {
                KeystoreService keystoreService = ServiceLocator.getInstance().getService(reference);
                keystoreService.setEntry(alias, (KeyStore.Entry)entry);
                ServiceLocator.getInstance().ungetService(reference);
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | GeneralSecurityException | KuraException e) {
            logger.error("Error storing keypair with alias: {} in keystore: {}", new Object[]{alias, keyStorePid, e});
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }

    @Override
    public void storeCertificate(GwtXSRFToken xsrfToken, String keyStorePid, String certificate, String alias) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            X509Certificate[] certs = KeystoreRemoteService.parsePublicCertificates((String)certificate);
            if (certs.length == 0) {
                throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
            }
            CertificatesService certificateService = ServiceLocator.getInstance().getService(CertificatesService.class);
            certificateService.addCertificate(new KuraCertificateEntry(keyStorePid, alias, (Certificate)certs[0]));
        }
        catch (CertificateException e) {
            logger.error("Error parsing certificate with alias: {} in keystore: {}", new Object[]{alias, keyStorePid, e});
            throw new GwtKuraException(GwtKuraErrorCode.CERTIFICATE_PARSE_FAILURE);
        }
        catch (IllegalArgumentException | IllegalStateException | KuraException e) {
            logger.error("Error storing certificate with alias: {} in keystore: {}. Illegal argument provided.", new Object[]{alias, keyStorePid, e});
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }

    @Override
    public List<String> listKeystoreServicePids() throws GwtKuraException {
        ArrayList<String> pids = new ArrayList<String>();
        ServiceLocator.withAllServiceReferences(null, (r, c) -> {
            Object pid = r.getProperties().get(KURA_SERVICE_PID);
            if (pid instanceof String) {
                pids.add((String)pid);
            }
        }, KeystoreService.class);
        return pids;
    }

    @Override
    public List<GwtKeystoreEntry> listEntries() throws GwtKuraException {
        ArrayList<GwtKeystoreEntry> result = new ArrayList<GwtKeystoreEntry>();
        ServiceLocator.withAllServiceReferences(KeystoreService.class, null, (ref, context) -> {
            Object kuraServicePid = ref.getProperty(KURA_SERVICE_PID);
            if (!(kuraServicePid instanceof String)) {
                return;
            }
            KeystoreService service = (KeystoreService)context.getService(ref);
            if (service == null) {
                return;
            }
            try {
                try {
                    for (Map.Entry e : service.getEntries().entrySet()) {
                        GwtKeystoreEntry.Kind kind;
                        Date validityStartDate = null;
                        Date validityEndDate = null;
                        if (e.getValue() instanceof KeyStore.PrivateKeyEntry) {
                            Certificate leaf;
                            kind = GwtKeystoreEntry.Kind.KEY_PAIR;
                            KeyStore.PrivateKeyEntry pke = (KeyStore.PrivateKeyEntry)e.getValue();
                            Certificate[] chain = pke.getCertificateChain();
                            if (chain.length > 0 && (leaf = chain[chain.length - 1]) instanceof X509Certificate) {
                                validityStartDate = ((X509Certificate)leaf).getNotBefore();
                                validityEndDate = ((X509Certificate)leaf).getNotAfter();
                            }
                        } else if (e.getValue() instanceof KeyStore.TrustedCertificateEntry) {
                            kind = GwtKeystoreEntry.Kind.TRUSTED_CERT;
                            Certificate cert = ((KeyStore.TrustedCertificateEntry)e.getValue()).getTrustedCertificate();
                            if (cert instanceof X509Certificate) {
                                validityStartDate = ((X509Certificate)cert).getNotBefore();
                                validityEndDate = ((X509Certificate)cert).getNotAfter();
                            }
                        } else {
                            if (!(e.getValue() instanceof KeyStore.SecretKeyEntry)) continue;
                            kind = GwtKeystoreEntry.Kind.SECRET_KEY;
                        }
                        result.add(new GwtKeystoreEntry((String)e.getKey(), (String)kuraServicePid, kind, validityStartDate, validityEndDate));
                    }
                }
                catch (KuraException keystoreException) {
                    logger.error("Error while accessing keystore file of Keystore Service {}: {}", new Object[]{(String)kuraServicePid, keystoreException.getMessage(), keystoreException});
                    context.ungetService(ref);
                }
            }
            finally {
                context.ungetService(ref);
            }
        });
        return result;
    }

    @Override
    public void removeEntry(GwtXSRFToken xsrfToken, GwtKeystoreEntry entry) throws GwtKuraException {
        Collection<ServiceReference<KeystoreService>> refs = ServiceLocator.getInstance().getServiceReferences(KeystoreService.class, "(kura.service.pid=" + entry.getKeystoreName() + ")");
        if (refs.isEmpty()) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
        for (ServiceReference<KeystoreService> ref : refs) {
            KeystoreService service = ServiceLocator.getInstance().getService(ref);
            if (service == null) continue;
            try {
                try {
                    service.deleteEntry(entry.getAlias());
                }
                catch (Exception e) {
                    logger.error("Error deleting keystore entry: {}", (Object)entry.getAlias(), (Object)e);
                    throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
                }
            }
            finally {
                ServiceLocator.getInstance().ungetService(ref);
            }
        }
    }
}

