/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.system;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import org.eclipse.kura.core.inventory.resources.SystemResourcesInfo;
import org.eclipse.kura.system.SystemResourceInfo;

public class JsonJavaSystemResourcesMapper {
    private static final String INVENTORY = "inventory";
    private static final String RESOURCE_NAME = "name";
    private static final String RESOURCE_VERSION = "version";
    private static final String RESOURCE_TYPE = "type";

    private JsonJavaSystemResourcesMapper() {
    }

    public static String marshal(SystemResourcesInfo systemResourcesInfo) {
        JsonObject json = Json.object();
        JsonArray resources = new JsonArray();
        systemResourcesInfo.getSystemResources().stream().forEach(sri -> {
            JsonArray jsonArray2 = resources.add((JsonValue)JsonJavaSystemResourcesMapper.getJsonSystemResource(sri));
        });
        json.add(INVENTORY, (JsonValue)resources);
        return json.toString();
    }

    private static JsonObject getJsonSystemResource(SystemResourceInfo sri) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(RESOURCE_NAME, sri.getName());
        jsonObject.add(RESOURCE_VERSION, sri.getVersion());
        jsonObject.add(RESOURCE_TYPE, sri.getTypeString());
        return jsonObject;
    }
}

