/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public abstract class PGPKeyRing {
    PGPKeyRing() {
    }

    static BCPGInputStream wrap(InputStream inputStream) {
        if (inputStream instanceof BCPGInputStream) {
            return (BCPGInputStream)inputStream;
        }
        return new BCPGInputStream(inputStream);
    }

    static TrustPacket readOptionalTrustPacket(BCPGInputStream bCPGInputStream) throws IOException {
        int n = bCPGInputStream.skipMarkerPackets();
        return n == 12 ? (TrustPacket)bCPGInputStream.readPacket() : null;
    }

    static List readSignaturesAndTrust(BCPGInputStream bCPGInputStream) throws IOException {
        try {
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
            while (bCPGInputStream.skipMarkerPackets() == 2) {
                SignaturePacket signaturePacket = (SignaturePacket)bCPGInputStream.readPacket();
                TrustPacket trustPacket = PGPKeyRing.readOptionalTrustPacket(bCPGInputStream);
                arrayList.add(new PGPSignature(signaturePacket, trustPacket));
            }
            return arrayList;
        }
        catch (PGPException pGPException) {
            throw new IOException("can't create signature object: " + pGPException.getMessage() + ", cause: " + pGPException.getUnderlyingException().toString());
        }
    }

    static void readUserIDs(BCPGInputStream bCPGInputStream, List list, List list2, List list3) throws IOException {
        while (PGPKeyRing.isUserTag(bCPGInputStream.skipMarkerPackets())) {
            ContainedPacket containedPacket;
            Packet packet = bCPGInputStream.readPacket();
            if (packet instanceof UserIDPacket) {
                containedPacket = (UserIDPacket)packet;
                list.add(containedPacket);
            } else {
                containedPacket = (UserAttributePacket)packet;
                list.add(new PGPUserAttributeSubpacketVector(((UserAttributePacket)containedPacket).getSubpackets()));
            }
            list2.add(PGPKeyRing.readOptionalTrustPacket(bCPGInputStream));
            list3.add(PGPKeyRing.readSignaturesAndTrust(bCPGInputStream));
        }
    }

    public abstract PGPPublicKey getPublicKey();

    public abstract Iterator<PGPPublicKey> getPublicKeys();

    public abstract PGPPublicKey getPublicKey(long var1);

    public abstract PGPPublicKey getPublicKey(byte[] var1);

    public abstract Iterator<PGPPublicKey> getKeysWithSignaturesBy(long var1);

    public abstract void encode(OutputStream var1) throws IOException;

    public abstract byte[] getEncoded() throws IOException;

    private static boolean isUserTag(int n) {
        switch (n) {
            case 13: 
            case 17: {
                return true;
            }
        }
        return false;
    }
}

