/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.TreeSet;
import org.apache.camel.processor.resequencer.SequenceElementComparator;

public class Sequence<E>
extends TreeSet<E> {
    private static final long serialVersionUID = 5647393631147741711L;
    private SequenceElementComparator<E> comparator;

    public Sequence(SequenceElementComparator<E> comparator) {
        super(comparator);
        this.comparator = comparator;
    }

    public E predecessor(E e) {
        E elem = this.lower(e);
        if (elem == null) {
            return null;
        }
        if (this.comparator.predecessor(elem, e)) {
            return elem;
        }
        return null;
    }

    public E successor(E e) {
        E elem = this.higher(e);
        if (elem == null) {
            return null;
        }
        if (this.comparator.successor(elem, e)) {
            return elem;
        }
        return null;
    }

    @Override
    public SequenceElementComparator<E> comparator() {
        return this.comparator;
    }

    @Override
    public E higher(E e) {
        boolean found = false;
        for (Object current : this) {
            if (found) {
                return current;
            }
            if (this.comparator.compare(e, current) != 0) continue;
            found = true;
        }
        return null;
    }

    @Override
    public E lower(E e) {
        E last = null;
        for (Object current : this) {
            if (this.comparator.compare(e, current) == 0) {
                return last;
            }
            last = current;
        }
        return last;
    }
}

