/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud.subscriber;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.listener.CloudConnectionListener;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.subscriber.CloudSubscriber;
import org.eclipse.kura.cloudconnection.subscriber.listener.CloudSubscriberListener;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.cloud.CloudServiceImpl;
import org.eclipse.kura.core.cloud.subscriber.CloudSubscriberOptions;
import org.eclipse.kura.core.message.MessageConstants;
import org.eclipse.kura.core.message.MessageType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudSubscriberImpl
implements CloudSubscriber,
ConfigurableComponent,
CloudConnectionListener,
CloudSubscriberListener {
    private static final Logger logger = LoggerFactory.getLogger(CloudSubscriberImpl.class);
    private ServiceTrackerCustomizer<CloudConnectionManager, CloudConnectionManager> cloudServiceTrackerCustomizer;
    private ServiceTracker<CloudConnectionManager, CloudConnectionManager> cloudServiceTracker;
    private CloudSubscriberOptions cloudSubscriberOptions;
    private CloudServiceImpl cloudService;
    private BundleContext bundleContext;
    private final Set<CloudSubscriberListener> subscribers = new CopyOnWriteArraySet<CloudSubscriberListener>();
    private final Set<CloudConnectionListener> cloudConnectionListeners = new CopyOnWriteArraySet<CloudConnectionListener>();

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Cloud Publisher...");
        this.bundleContext = componentContext.getBundleContext();
        this.cloudServiceTrackerCustomizer = new CloudServiceTrackerCustomizer();
        this.doUpdate(properties);
        logger.debug("Activating Cloud Publisher... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Cloud Publisher...");
        this.doUpdate(properties);
        logger.debug("Updating Cloud Publisher... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating Cloud Publisher...");
        if (Objects.nonNull(this.cloudServiceTracker)) {
            this.cloudServiceTracker.close();
        }
        logger.debug("Deactivating Cloud Publisher... Done");
    }

    private void doUpdate(Map<String, Object> properties) {
        this.cloudSubscriberOptions = new CloudSubscriberOptions(properties);
        if (Objects.nonNull(this.cloudServiceTracker)) {
            this.cloudServiceTracker.close();
        }
        this.initCloudServiceTracking();
    }

    private void initCloudServiceTracking() {
        String selectedCloudServicePid = this.cloudSubscriberOptions.getCloudServicePid();
        String filterString = String.format("(&(%s=%s)(kura.service.pid=%s))", "objectClass", CloudConnectionManager.class.getName(), selectedCloudServicePid);
        Filter filter = null;
        try {
            filter = this.bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            logger.error("Filter setup exception ", (Throwable)e);
        }
        this.cloudServiceTracker = new ServiceTracker(this.bundleContext, filter, this.cloudServiceTrackerCustomizer);
        this.cloudServiceTracker.open();
    }

    public void registerCloudSubscriberListener(CloudSubscriberListener listener) {
        this.subscribers.add(listener);
    }

    public void unregisterCloudSubscriberListener(CloudSubscriberListener listener) {
        this.subscribers.remove(listener);
    }

    public void onConnectionEstablished() {
        this.cloudConnectionListeners.forEach(CloudConnectionListener::onConnectionEstablished);
    }

    public void onConnectionLost() {
        this.cloudConnectionListeners.forEach(CloudConnectionListener::onConnectionLost);
    }

    public void onDisconnected() {
        this.cloudConnectionListeners.forEach(CloudConnectionListener::onDisconnected);
    }

    public void registerCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.add(cloudConnectionListener);
    }

    public void unregisterCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.remove(cloudConnectionListener);
    }

    public void onMessageArrived(KuraMessage message) {
        this.subscribers.forEach(subscriber -> subscriber.onMessageArrived(message));
    }

    private final class CloudServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<CloudConnectionManager, CloudConnectionManager> {
        private CloudServiceTrackerCustomizer() {
        }

        public CloudConnectionManager addingService(ServiceReference<CloudConnectionManager> reference) {
            CloudConnectionManager tempCloudService = (CloudConnectionManager)CloudSubscriberImpl.this.bundleContext.getService(reference);
            if (tempCloudService instanceof CloudServiceImpl) {
                CloudSubscriberImpl.this.cloudService = (CloudServiceImpl)tempCloudService;
                HashMap<String, Object> subscriptionProps = new HashMap<String, Object>();
                subscriptionProps.put(MessageConstants.APP_ID.name(), CloudSubscriberImpl.this.cloudSubscriberOptions.getAppId());
                subscriptionProps.put(MessageConstants.APP_TOPIC.name(), CloudSubscriberImpl.this.cloudSubscriberOptions.getAppTopic());
                subscriptionProps.put(MessageConstants.QOS.name(), CloudSubscriberImpl.this.cloudSubscriberOptions.getQos());
                subscriptionProps.put(MessageConstants.CONTROL.name(), MessageType.CONTROL.equals((Object)CloudSubscriberImpl.this.cloudSubscriberOptions.getMessageType()));
                CloudSubscriberImpl.this.cloudService.registerSubscriber(subscriptionProps, CloudSubscriberImpl.this);
                CloudSubscriberImpl.this.cloudService.registerCloudConnectionListener(CloudSubscriberImpl.this);
                return tempCloudService;
            }
            CloudSubscriberImpl.this.bundleContext.ungetService(reference);
            return null;
        }

        public void removedService(ServiceReference<CloudConnectionManager> reference, CloudConnectionManager service) {
            CloudSubscriberImpl.this.cloudService.unregisterSubscriber(CloudSubscriberImpl.this);
            CloudSubscriberImpl.this.cloudService.unregisterCloudConnectionListener(CloudSubscriberImpl.this);
            CloudSubscriberImpl.this.cloudService = null;
        }

        public void modifiedService(ServiceReference<CloudConnectionManager> reference, CloudConnectionManager service) {
        }
    }
}

