/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.util.configuration.Property;

public class SslManagerServiceOptions {
    public static final String PROP_PROTOCOL = "ssl.default.protocol";
    public static final String PROP_CIPHERS = "ssl.default.cipherSuites";
    public static final String PROP_HN_VERIFY = "ssl.hostname.verification";
    public static final Boolean PROP_DEFAULT_HN_VERIFY = true;
    public static final String PROP_DEFAULT_TRUST_PASSWORD = "changeit";
    private static final Property<String> SELECTED_SSL_PROTOCOL = new Property("ssl.default.protocol", (Object)"");
    private static final Property<String> SELECTED_SSL_CIPHERS = new Property("ssl.default.cipherSuites", (Object)"");
    private static final Property<Boolean> SELECTED_SSL_HN_VERIFICATION = new Property("ssl.hostname.verification", (Object)PROP_DEFAULT_HN_VERIFY);
    private static final Property<Boolean> SSL_REVOCATION_CHECK_ENABLED = new Property("ssl.revocation.check.enabled", (Object)false);
    private static final Property<Boolean> SSL_REVOCATION_SOFT_FAIL = new Property("ssl.revocation.soft.fail", (Object)false);
    private static final Property<String> SSL_REVOCATION_MODE = new Property("ssl.revocation.mode", (Object)RevocationCheckMode.PREFER_OCSP.name());
    private final Map<String, Object> properties;
    private final String sslProtocol;
    private final String sslCiphers;
    private final boolean sslHNVerification;
    private final boolean sslRevocationCheckEnabled;
    private final RevocationCheckMode sslRevocationMode;
    private final boolean sslRevocationSoftFail;

    public SslManagerServiceOptions(Map<String, Object> properties) {
        if (Objects.isNull(properties)) {
            throw new IllegalArgumentException("SSL Options cannot be null!");
        }
        this.properties = properties;
        this.sslProtocol = ((String)SELECTED_SSL_PROTOCOL.get(properties)).trim();
        this.sslCiphers = ((String)SELECTED_SSL_CIPHERS.get(properties)).trim();
        this.sslHNVerification = (Boolean)SELECTED_SSL_HN_VERIFICATION.get(properties);
        this.sslRevocationCheckEnabled = (Boolean)SSL_REVOCATION_CHECK_ENABLED.get(properties);
        this.sslRevocationMode = RevocationCheckMode.valueOf((String)SSL_REVOCATION_MODE.get(properties));
        this.sslRevocationSoftFail = (Boolean)SSL_REVOCATION_SOFT_FAIL.get(properties);
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.properties;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String getSslCiphers() {
        return this.sslCiphers;
    }

    public Boolean isSslHostnameVerification() {
        return this.sslHNVerification;
    }

    public boolean isSslRevocationCheckEnabled() {
        return this.sslRevocationCheckEnabled;
    }

    public RevocationCheckMode getRevocationCheckMode() {
        return this.sslRevocationMode;
    }

    public boolean isSslRevocationSoftFail() {
        return this.sslRevocationSoftFail;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslManagerServiceOptions)) {
            return false;
        }
        SslManagerServiceOptions other = (SslManagerServiceOptions)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public static enum RevocationCheckMode {
        PREFER_OCSP,
        PREFER_CRL,
        CRL_ONLY;

    }
}

