/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.xml.marshaller.unmarshaller;

import java.util.List;
import org.eclipse.kura.core.inventory.resources.SystemResourcesInfo;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaDataMapper;
import org.eclipse.kura.system.SystemResourceInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlJavaSystemResourcesMapper
implements XmlJavaDataMapper {
    private static final String SYSTEM_INVENTORY = "inventory";
    private static final String SYSTEM_INVENTORY_RESOURCE = "resource";
    private static final String SYSTEM_INVENTORY_RESOURCE_NAME = "name";
    private static final String SYSTEM_INVENTORY_RESOURCE_VERSION = "version";
    private static final String SYSTEM_INVENTORY_RESOURCE_TYPE = "type";

    @Override
    public Element marshal(Document doc, Object object) throws Exception {
        Element inventory = doc.createElement(SYSTEM_INVENTORY);
        doc.appendChild(inventory);
        SystemResourcesInfo xmlInventory = (SystemResourcesInfo)object;
        List xmlResourceList = xmlInventory.getSystemResources();
        xmlResourceList.stream().forEach(xmlResource -> {
            Element p = doc.createElement(SYSTEM_INVENTORY_RESOURCE);
            XmlJavaSystemResourcesMapper.marshallResource(doc, xmlResource, p);
            inventory.appendChild(p);
        });
        return inventory;
    }

    @Override
    public <T> T unmarshal(Document doc) throws Exception {
        return null;
    }

    private static void marshallResource(Document doc, SystemResourceInfo systemResourceInfo, Element p) {
        String resourceName = systemResourceInfo.getName();
        String resourceVersion = systemResourceInfo.getVersion();
        String resourceType = systemResourceInfo.getTypeString();
        if (resourceName != null && !resourceName.trim().isEmpty()) {
            Element name = doc.createElement(SYSTEM_INVENTORY_RESOURCE_NAME);
            name.setTextContent(resourceName);
            p.appendChild(name);
        }
        if (resourceVersion != null && !resourceVersion.trim().isEmpty()) {
            Element version = doc.createElement(SYSTEM_INVENTORY_RESOURCE_VERSION);
            version.setTextContent(resourceVersion);
            p.appendChild(version);
        }
        if (resourceType != null && !resourceType.trim().isEmpty()) {
            Element type = doc.createElement(SYSTEM_INVENTORY_RESOURCE_TYPE);
            type.setTextContent(resourceType);
            p.appendChild(type);
        }
    }
}

