/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.kura.asset.Asset;
import org.eclipse.kura.channel.ChannelFlag;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelStatus;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.internal.wire.asset.WireAssetChannelDescriptor;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.GwtComponentServiceInternal;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtChannelOperationResult;
import org.eclipse.kura.web.shared.model.GwtChannelRecord;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtDriverAndAssetService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class GwtDriverAndAssetServiceImpl
extends OsgiRemoteServiceServlet
implements GwtDriverAndAssetService {
    private static final long serialVersionUID = 8627173534436639487L;
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final AtomicInteger nextId = new AtomicInteger();

    @Override
    public GwtChannelOperationResult readAllChannels(GwtXSRFToken xsrfToken, String assetPid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            ArrayList<GwtChannelRecord> result = new ArrayList<GwtChannelRecord>();
            this.withAsset(assetPid, asset -> {
                List assetData = asset.readAllChannels();
                for (ChannelRecord channelRecord : assetData) {
                    result.add(GwtDriverAndAssetServiceImpl.toGwt(channelRecord));
                }
            });
            return new GwtChannelOperationResult(result);
        }
        catch (Exception e) {
            return this.getFailureResult(e);
        }
    }

    @Override
    public GwtConfigComponent getUploadedCsvConfig(GwtXSRFToken xsrfToken, String assetPid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        HttpSession session = this.getThreadLocalRequest().getSession(false);
        String key = "kura.csv.config." + assetPid;
        GwtConfigComponent result = (GwtConfigComponent)session.getAttribute(key);
        if (result == null) {
            throw new GwtKuraException("Uploaded configuration not available");
        }
        session.removeAttribute(key);
        return result;
    }

    @Override
    public GwtChannelOperationResult write(GwtXSRFToken xsrfToken, String assetPid, List<GwtChannelRecord> gwtChannelRecords) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            HashMap<String, GwtChannelRecord> groupedRecords = new HashMap<String, GwtChannelRecord>(gwtChannelRecords.size());
            for (GwtChannelRecord record : gwtChannelRecords) {
                record.setUnescaped(true);
                groupedRecords.put(record.getName(), record);
            }
            ArrayList<ChannelRecord> channelRecords = new ArrayList<ChannelRecord>();
            for (GwtChannelRecord gwtChannelData : gwtChannelRecords) {
                String channelName = gwtChannelData.getName();
                String typedValue = gwtChannelData.getValueType();
                String value = gwtChannelData.getValue();
                try {
                    channelRecords.add(ChannelRecord.createWriteRecord((String)channelName, GwtDriverAndAssetServiceImpl.parseTypedValue(value, typedValue)));
                }
                catch (Exception e) {
                    gwtChannelData.setValue(null);
                    gwtChannelData.setExceptionMessage(e.getMessage());
                    gwtChannelData.setExceptionStackTrace(e.getStackTrace());
                }
            }
            this.withAsset(assetPid, asset -> asset.write(channelRecords));
            for (ChannelRecord record : channelRecords) {
                GwtChannelRecord gwtChannelRecord = (GwtChannelRecord)groupedRecords.get(record.getChannelName());
                ChannelStatus status = record.getChannelStatus();
                if (status.getChannelFlag() != ChannelFlag.FAILURE) continue;
                GwtDriverAndAssetServiceImpl.fillErrorData(status, gwtChannelRecord);
            }
            return new GwtChannelOperationResult(gwtChannelRecords);
        }
        catch (Exception e) {
            return this.getFailureResult(e);
        }
    }

    private GwtChannelOperationResult getFailureResult(Throwable e) {
        Throwable rootCause = e.getCause();
        if (rootCause != null) {
            return new GwtChannelOperationResult(rootCause);
        }
        return new GwtChannelOperationResult(e);
    }

    private void withAsset(String kuraServicePid, ServiceLocator.ServiceConsumer<Asset> consumer) throws Exception {
        String filter;
        BundleContext ctx = FrameworkUtil.getBundle(ServiceLocator.class).getBundleContext();
        Collection refs = ctx.getServiceReferences(Asset.class, filter = String.format("(%s=%s)", "kura.service.pid", kuraServicePid));
        if (refs == null || refs.isEmpty()) {
            return;
        }
        ServiceReference assetRef = (ServiceReference)refs.iterator().next();
        try {
            consumer.consume((Asset)ctx.getService(assetRef));
        }
        finally {
            ctx.ungetService(assetRef);
        }
    }

    private static GwtChannelRecord toGwt(ChannelRecord channelRecord) {
        GwtChannelRecord channelData = new GwtChannelRecord();
        channelData.setName(channelRecord.getChannelName());
        channelData.setValueType(channelRecord.getValueType().toString());
        ChannelStatus status = channelRecord.getChannelStatus();
        if (ChannelFlag.SUCCESS.equals((Object)status.getChannelFlag())) {
            channelData.setValue(GwtDriverAndAssetServiceImpl.typedValueToString(channelRecord.getValue()));
        } else {
            GwtDriverAndAssetServiceImpl.fillErrorData(status, channelData);
        }
        return channelData;
    }

    private static void fillErrorData(ChannelStatus status, GwtChannelRecord record) {
        record.setValue(null);
        Exception exception = status.getException();
        String userMessage = status.getExceptionMessage();
        String exceptionMessage = exception != null ? exception.getMessage() : null;
        StringBuilder exceptionMessageBuilder = new StringBuilder();
        if (userMessage != null) {
            exceptionMessageBuilder.append(userMessage);
        }
        if (exceptionMessage != null && !exceptionMessage.equals(userMessage)) {
            if (userMessage != null) {
                exceptionMessageBuilder.append(" - ");
            }
            exceptionMessageBuilder.append(exceptionMessage);
        }
        record.setExceptionMessage(exceptionMessageBuilder.toString());
        if (exception != null) {
            record.setExceptionStackTrace(exception.getStackTrace());
        }
    }

    private static TypedValue<?> parseTypedValue(String userValue, String userType) {
        DataType dataType = DataType.getDataType((String)userType);
        if (DataType.INTEGER == dataType) {
            return TypedValues.newIntegerValue((int)Integer.parseInt(userValue));
        }
        if (DataType.BOOLEAN == dataType) {
            return TypedValues.newBooleanValue((boolean)Boolean.parseBoolean(userValue));
        }
        if (DataType.FLOAT == dataType) {
            return TypedValues.newFloatValue((float)Float.parseFloat(userValue));
        }
        if (DataType.DOUBLE == dataType) {
            return TypedValues.newDoubleValue((double)Double.parseDouble(userValue));
        }
        if (DataType.LONG == dataType) {
            return TypedValues.newLongValue((long)Long.parseLong(userValue));
        }
        if (DataType.STRING == dataType) {
            return TypedValues.newStringValue((String)userValue);
        }
        if (DataType.BYTE_ARRAY == dataType) {
            return TypedValues.newByteArrayValue((byte[])BASE64_DECODER.decode(userValue));
        }
        throw new IllegalArgumentException();
    }

    private static String typedValueToString(TypedValue<?> typedValue) {
        if (typedValue.getType() == DataType.BYTE_ARRAY) {
            return BASE64_ENCODER.encodeToString((byte[])typedValue.getValue());
        }
        return typedValue.getValue().toString();
    }

    @Override
    public int convertToCsv(GwtXSRFToken token, String driverPid, GwtConfigComponent assetConfig) throws GwtKuraException, IOException {
        this.checkXSRFToken(token);
        List wireAssetDescriptor = (List)WireAssetChannelDescriptor.get().getDescriptor();
        ArrayList<AD> channelDescriptor = new ArrayList<AD>();
        for (AD ad : wireAssetDescriptor) {
            channelDescriptor.add(ad);
        }
        ServiceLocator.withAllServices(Driver.class, "(kura.service.pid=" + driverPid + ")", d -> {
            List desc = (List)d.getChannelDescriptor().getDescriptor();
            channelDescriptor.addAll(desc);
        });
        if (channelDescriptor.size() == wireAssetDescriptor.size()) {
            throw new GwtKuraException("Driver not found");
        }
        TreeSet channelNames = new TreeSet();
        HashMap paramsById = new HashMap();
        assetConfig.getParameters().forEach(p -> {
            String id = p.getId();
            int index = id.indexOf(35);
            if (index == -1) {
                return;
            }
            channelNames.add(id.substring(0, index));
            paramsById.put(id, p);
        });
        StringWriter out = new StringWriter();
        Throwable throwable = null;
        Object var10_12 = null;
        try (CSVPrinter printer = new CSVPrinter((Appendable)out, CSVFormat.RFC4180);){
            int i = 0;
            while (i < channelDescriptor.size()) {
                String id = ((AD)channelDescriptor.get(i)).getId();
                if (i < wireAssetDescriptor.size()) {
                    printer.print((Object)id.substring(1));
                } else {
                    printer.print((Object)id);
                }
                ++i;
            }
            printer.println();
            for (String channel : channelNames) {
                for (AD ad : channelDescriptor) {
                    String key = String.valueOf(channel) + '#' + ad.getId();
                    GwtConfigParameter param = (GwtConfigParameter)paramsById.get(key);
                    printer.print((Object)(param != null ? param.getValue() : null));
                }
                printer.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int id = nextId.getAndIncrement();
        HttpSession session = this.getThreadLocalRequest().getSession(false);
        session.setAttribute("kura.csv.download." + id, (Object)((Object)out).toString());
        return id;
    }

    @Override
    public void createDriverOrAssetConfiguration(GwtXSRFToken token, String factoryPid, String pid) throws GwtKuraException {
        this.checkXSRFToken(token);
        GwtDriverAndAssetServiceImpl.requireIsDriverOrAssetFactory(factoryPid);
        GwtComponentServiceInternal.createFactoryComponent(factoryPid, pid);
    }

    @Override
    public void createDriverOrAssetConfiguration(GwtXSRFToken token, String factoryPid, String pid, GwtConfigComponent config) throws GwtKuraException {
        this.checkXSRFToken(token);
        GwtDriverAndAssetServiceImpl.requireIsDriverOrAssetFactory(factoryPid);
        GwtComponentServiceInternal.createFactoryComponent(factoryPid, pid, config);
    }

    @Override
    public void updateDriverOrAssetConfiguration(GwtXSRFToken token, GwtConfigComponent config) throws GwtKuraException {
        this.checkXSRFToken(token);
        GwtDriverAndAssetServiceImpl.requireIsDriverOrAsset(config.getComponentId());
        GwtComponentServiceInternal.updateComponentConfiguration(config);
    }

    @Override
    public void deleteDriverOrAssetConfiguration(GwtXSRFToken token, String pid, boolean takeSnapshot) throws GwtKuraException {
        this.checkXSRFToken(token);
        GwtDriverAndAssetServiceImpl.requireIsDriverOrAsset(pid);
        GwtComponentServiceInternal.deleteFactoryConfiguration(pid, takeSnapshot);
    }

    private static void requireIsDriverOrAssetFactory(String factoryPid) throws GwtKuraException {
        if (!GwtServerUtil.isFactoryOfAnyService(factoryPid, Driver.class) && !GwtServerUtil.isFactoryOfAnyService(factoryPid, Asset.class)) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }

    private static void requireIsDriverOrAsset(String kuraServicePid) throws GwtKuraException {
        if (!GwtServerUtil.providesService(kuraServicePid, Driver.class) && !GwtServerUtil.providesService(kuraServicePid, Asset.class)) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
        }
    }
}

