/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset.cloudlet;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.asset.Asset;
import org.eclipse.kura.asset.AssetService;
import org.eclipse.kura.channel.Channel;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelType;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.internal.asset.cloudlet.AssetTrackerCustomizer;
import org.eclipse.kura.internal.asset.cloudlet.serialization.request.MetadataRequest;
import org.eclipse.kura.internal.asset.cloudlet.serialization.request.ReadRequest;
import org.eclipse.kura.internal.asset.cloudlet.serialization.request.WriteRequest;
import org.eclipse.kura.internal.asset.cloudlet.serialization.response.ChannelOperationResponse;
import org.eclipse.kura.internal.asset.cloudlet.serialization.response.MetadataResponse;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssetCloudlet
implements RequestHandler {
    private static final String UNKNOWN_ERROR_MESSAGE = "Unknown error";
    private static final String ASSET_TOPIC_RESOURCE = "assets";
    private static final String READ_TOPIC_RESOURCE = "read";
    private static final String WRITE_TOPIC_RESOURCE = "write";
    private static final String APP_ID = "ASSET-V1";
    private static final Logger logger = LoggerFactory.getLogger(AssetCloudlet.class);
    private Map<String, Asset> assets;
    private volatile AssetService assetService;
    private AssetTrackerCustomizer assetTrackerCustomizer;
    private ServiceTracker<Asset, Asset> assetServiceTracker;

    protected synchronized void bindAssetService(AssetService assetService) {
        if (this.assetService == null) {
            this.assetService = assetService;
        }
    }

    protected synchronized void unbindAssetService(AssetService assetService) {
        if (this.assetService == assetService) {
            this.assetService = null;
        }
    }

    public void setRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.registerRequestHandler(APP_ID, (RequestHandler)this);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    public void unsetRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.unregister(APP_ID);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    protected synchronized void activate(ComponentContext componentContext) {
        logger.debug("Activating Asset Cloudlet...");
        this.assetTrackerCustomizer = new AssetTrackerCustomizer(componentContext.getBundleContext(), this.assetService);
        this.assetServiceTracker = new ServiceTracker(componentContext.getBundleContext(), Asset.class.getName(), (ServiceTrackerCustomizer)this.assetTrackerCustomizer);
        this.assetServiceTracker.open();
        logger.debug("Activating Asset Cloudlet...Done");
    }

    protected synchronized void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating Asset Cloudlet...");
        this.assetServiceTracker.close();
        logger.debug("Deactivating Asset Cloudlet...Done");
    }

    private void findAssets() {
        this.assets = this.assetTrackerCustomizer.getRegisteredAssets();
    }

    private JsonArray parseRequest(KuraPayload reqPayload) {
        byte[] rawBody = reqPayload.getBody();
        if (rawBody == null) {
            return null;
        }
        return Json.parse((String)new String(rawBody, StandardCharsets.UTF_8)).asArray();
    }

    private KuraPayload getAssetMetadata(Iterator<String> assetNames) {
        KuraResponsePayload responsePayload = new KuraResponsePayload(200);
        MetadataResponse response = new MetadataResponse();
        assetNames.forEachRemaining(assetName -> {
            Asset asset = this.assets.get(assetName);
            if (asset == null) {
                response.reportAssetNotFound((String)assetName);
            } else {
                response.addAssetMetadata((String)assetName, asset);
            }
        });
        responsePayload.setBody(response.serialize());
        return responsePayload;
    }

    public KuraMessage doGet(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        KuraPayload responsePayload;
        JsonArray request;
        logger.info("Cloudlet GET Request received on the Asset Cloudlet...");
        List<String> resources = this.getRequestResources(reqMessage);
        if (resources.size() != 1 || !ASSET_TOPIC_RESOURCE.equals(resources.get(0))) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        this.findAssets();
        try {
            request = this.parseRequest(reqMessage.getPayload());
        }
        catch (Exception exception) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (request == null || request.isEmpty()) {
            responsePayload = this.getAssetMetadata(this.assets.keySet().iterator());
        } else {
            MetadataRequest parsedRequest;
            try {
                parsedRequest = new MetadataRequest(request);
            }
            catch (Exception exception) {
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
            responsePayload = this.getAssetMetadata(parsedRequest.getAssetNames().iterator());
        }
        return new KuraMessage(responsePayload);
    }

    private List<String> getRequestResources(KuraMessage reqMessage) throws KuraException {
        Object requestObject = reqMessage.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value());
        if (!(requestObject instanceof List)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        List resources = (List)requestObject;
        return resources;
    }

    public KuraMessage doExec(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        KuraPayload resPayload;
        logger.info("Cloudlet EXEC Request received on the Asset Cloudlet...");
        List<String> resources = this.getRequestResources(reqMessage);
        if (resources.size() != 1) {
            logger.error("Bad request topic: {}", resources);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (READ_TOPIC_RESOURCE.equals(resources.get(0))) {
            resPayload = this.read(reqMessage.getPayload());
        } else if (WRITE_TOPIC_RESOURCE.equals(resources.get(0))) {
            resPayload = this.write(reqMessage.getPayload());
        } else {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        return new KuraMessage(resPayload);
    }

    private void readAsset(String assetName, Set<String> channelNames, ChannelOperationResponse response) {
        Asset asset = this.assets.get(assetName);
        if (asset == null) {
            response.reportAssetNotFound(assetName);
            return;
        }
        try {
            if (channelNames.isEmpty()) {
                response.reportResult(assetName, asset.readAllChannels());
            } else {
                response.reportResult(assetName, asset.read(channelNames));
            }
        }
        catch (Exception e) {
            Set<String> filteredChannelNames = channelNames;
            if (channelNames.isEmpty()) {
                Map assetChannels = asset.getAssetConfiguration().getAssetChannels();
                filteredChannelNames = assetChannels.entrySet().stream().filter(entry -> ((Channel)entry.getValue()).getType() == ChannelType.READ || ((Channel)entry.getValue()).getType() == ChannelType.READ_WRITE).map(Map.Entry::getKey).collect(Collectors.toSet());
            }
            response.reportAllFailed(assetName, filteredChannelNames.iterator(), Optional.ofNullable(e.getMessage()).orElse(UNKNOWN_ERROR_MESSAGE));
        }
    }

    private ChannelOperationResponse readAllAssets() {
        ChannelOperationResponse response = new ChannelOperationResponse();
        for (Map.Entry<String, Asset> entry : this.assets.entrySet()) {
            String assetName = entry.getKey();
            Asset asset = entry.getValue();
            try {
                response.reportResult(assetName, asset.readAllChannels());
            }
            catch (Exception e) {
                response.reportAllFailed(assetName, asset.getAssetConfiguration().getAssetChannels().keySet().iterator(), Optional.ofNullable(e.getMessage()).orElse(UNKNOWN_ERROR_MESSAGE));
            }
        }
        return response;
    }

    private KuraPayload read(KuraPayload reqPayload) throws KuraException {
        ChannelOperationResponse response;
        JsonArray request;
        this.findAssets();
        try {
            request = this.parseRequest(reqPayload);
        }
        catch (Exception exception) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (request == null || request.isEmpty()) {
            response = this.readAllAssets();
        } else {
            List<ReadRequest> readRequests;
            try {
                readRequests = ReadRequest.parseAll(request);
            }
            catch (Exception exception) {
                throw new KuraException(KuraErrorCode.BAD_REQUEST);
            }
            response = new ChannelOperationResponse();
            for (ReadRequest readRequest : readRequests) {
                this.readAsset(readRequest.getAssetName(), readRequest.getChannelNames(), response);
            }
        }
        KuraResponsePayload responsePayload = new KuraResponsePayload(200);
        responsePayload.setBody(response.serialize());
        return responsePayload;
    }

    private void writeAsset(String assetName, List<ChannelRecord> channelRecords, ChannelOperationResponse response) {
        Asset asset = this.assets.get(assetName);
        if (asset == null) {
            response.reportAssetNotFound(assetName);
            return;
        }
        try {
            if (!channelRecords.isEmpty()) {
                asset.write(channelRecords);
            }
            response.reportResult(assetName, channelRecords);
        }
        catch (Exception e) {
            response.reportAllFailed(assetName, channelRecords.stream().map(ChannelRecord::getChannelName).iterator(), Optional.ofNullable(e.getMessage()).orElse(UNKNOWN_ERROR_MESSAGE));
        }
    }

    private KuraPayload write(KuraPayload reqPayload) throws KuraException {
        List<WriteRequest> writeRequests;
        this.findAssets();
        try {
            writeRequests = WriteRequest.parseAll(this.parseRequest(reqPayload));
        }
        catch (Exception exception) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        ChannelOperationResponse response = new ChannelOperationResponse();
        for (WriteRequest writeRequest : writeRequests) {
            this.writeAsset(writeRequest.getAssetName(), writeRequest.getChannelRecords(), response);
        }
        KuraResponsePayload responsePayload = new KuraResponsePayload(200);
        responsePayload.setBody(response.serialize());
        return responsePayload;
    }
}

