/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.service;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.annotation.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceUtil {
    private ServiceUtil() {
    }

    public static <T> ServiceReference<T>[] getServiceReferences(BundleContext bundleContext, Class<T> clazz, @Nullable String filter) {
        Objects.requireNonNull(bundleContext, "Bundle context cannot be null.");
        Objects.requireNonNull(clazz, "Class intance name cannot be null.");
        try {
            Collection refs = bundleContext.getServiceReferences(clazz, filter);
            return refs.toArray(new ServiceReference[0]);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    public static void ungetServiceReferences(BundleContext bundleContext, ServiceReference<?>[] refs) {
        Objects.requireNonNull(bundleContext, "Bundle context cannot be null.");
        Objects.requireNonNull(refs, "Service References cannot be null.");
        ServiceReference<?>[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> ref = serviceReferenceArray[n2];
            bundleContext.ungetService(ref);
            ++n2;
        }
    }

    public static Optional<Object> waitForService(String filter, long timeout, TimeUnit timeunit) throws InterruptedException, InvalidSyntaxException {
        Objects.requireNonNull(filter, "Filter cannot be null.");
        Objects.requireNonNull(timeunit, "TimeUnit cannot be null");
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout period cannot be zero or negative");
        }
        long timeoutInMillis = timeunit.toMillis(timeout);
        BundleContext bundleContext = FrameworkUtil.getBundle(ServiceUtil.class).getBundleContext();
        Filter filterRef = bundleContext.createFilter(filter);
        ServiceTracker serviceTracker = new ServiceTracker(bundleContext, filterRef, null);
        serviceTracker.open();
        Object service = serviceTracker.waitForService(timeoutInMillis);
        serviceTracker.close();
        return Optional.ofNullable(service);
    }
}

