/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.qpid.jms.exceptions.IdConversionException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedLong;

public class AmqpMessageIdHelper {
    public static final AmqpMessageIdHelper INSTANCE = new AmqpMessageIdHelper();
    public static final String AMQP_STRING_PREFIX = "AMQP_STRING:";
    public static final String AMQP_UUID_PREFIX = "AMQP_UUID:";
    public static final String AMQP_ULONG_PREFIX = "AMQP_ULONG:";
    public static final String AMQP_BINARY_PREFIX = "AMQP_BINARY:";
    public static final String AMQP_NO_PREFIX = "AMQP_NO_PREFIX:";
    public static final String JMS_ID_PREFIX = "ID:";
    private static final String AMQP_PREFIX = "AMQP_";
    private static final int JMS_ID_PREFIX_LENGTH = "ID:".length();
    private static final int AMQP_UUID_PREFIX_LENGTH = "AMQP_UUID:".length();
    private static final int AMQP_ULONG_PREFIX_LENGTH = "AMQP_ULONG:".length();
    private static final int AMQP_STRING_PREFIX_LENGTH = "AMQP_STRING:".length();
    private static final int AMQP_BINARY_PREFIX_LENGTH = "AMQP_BINARY:".length();
    private static final int AMQP_NO_PREFIX_LENGTH = "AMQP_NO_PREFIX:".length();
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public boolean hasMessageIdPrefix(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(JMS_ID_PREFIX);
    }

    public String toMessageIdString(Object idObject) {
        if (idObject instanceof String) {
            String stringId = (String)idObject;
            boolean hasMessageIdPrefix = this.hasMessageIdPrefix(stringId);
            if (!hasMessageIdPrefix) {
                return "ID:AMQP_NO_PREFIX:" + stringId;
            }
            if (this.hasTypeEncodingPrefix(stringId, JMS_ID_PREFIX_LENGTH)) {
                return "ID:AMQP_STRING:" + stringId;
            }
            return stringId;
        }
        return this.convertToIdString(idObject);
    }

    public String toCorrelationIdString(Object idObject) {
        if (idObject instanceof String) {
            String stringId = (String)idObject;
            boolean hasMessageIdPrefix = this.hasMessageIdPrefix(stringId);
            if (!hasMessageIdPrefix) {
                return stringId;
            }
            if (this.hasTypeEncodingPrefix(stringId, JMS_ID_PREFIX_LENGTH)) {
                return "ID:AMQP_STRING:" + stringId;
            }
            return stringId;
        }
        return this.convertToIdString(idObject);
    }

    private String convertToIdString(Object idObject) {
        if (idObject == null) {
            return null;
        }
        if (idObject instanceof UUID) {
            return "ID:AMQP_UUID:" + idObject.toString();
        }
        if (idObject instanceof UnsignedLong) {
            return "ID:AMQP_ULONG:" + idObject.toString();
        }
        if (idObject instanceof Binary) {
            ByteBuffer dup = ((Binary)idObject).asByteBuffer();
            byte[] bytes = new byte[dup.remaining()];
            dup.get(bytes);
            String hex = this.convertBinaryToHexString(bytes);
            return "ID:AMQP_BINARY:" + hex;
        }
        throw new IllegalArgumentException("Unsupported type provided: " + idObject.getClass());
    }

    private boolean hasTypeEncodingPrefix(String stringId, int offset) {
        if (!stringId.startsWith(AMQP_PREFIX, offset)) {
            return false;
        }
        return this.hasAmqpBinaryPrefix(stringId, offset) || this.hasAmqpUuidPrefix(stringId, offset) || this.hasAmqpUlongPrefix(stringId, offset) || this.hasAmqpStringPrefix(stringId, offset) || this.hasAmqpNoPrefix(stringId, offset);
    }

    private boolean hasAmqpStringPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_STRING_PREFIX, offset);
    }

    private boolean hasAmqpUlongPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_ULONG_PREFIX, offset);
    }

    private boolean hasAmqpUuidPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_UUID_PREFIX, offset);
    }

    private boolean hasAmqpBinaryPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_BINARY_PREFIX, offset);
    }

    private boolean hasAmqpNoPrefix(String stringId, int offset) {
        return stringId.startsWith(AMQP_NO_PREFIX, offset);
    }

    public Object toIdObject(String origId) throws IdConversionException {
        if (origId == null) {
            return null;
        }
        if (!INSTANCE.hasMessageIdPrefix(origId)) {
            return origId;
        }
        try {
            if (this.hasAmqpNoPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                return origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_NO_PREFIX_LENGTH);
            }
            if (this.hasAmqpUuidPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                String uuidString = origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_UUID_PREFIX_LENGTH);
                return UUID.fromString(uuidString);
            }
            if (this.hasAmqpUlongPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                String ulongString = origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_ULONG_PREFIX_LENGTH);
                return UnsignedLong.valueOf((String)ulongString);
            }
            if (this.hasAmqpStringPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                return origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_STRING_PREFIX_LENGTH);
            }
            if (this.hasAmqpBinaryPrefix(origId, JMS_ID_PREFIX_LENGTH)) {
                String hexString = origId.substring(JMS_ID_PREFIX_LENGTH + AMQP_BINARY_PREFIX_LENGTH);
                byte[] bytes = this.convertHexStringToBinary(hexString);
                return new Binary(bytes);
            }
            return origId;
        }
        catch (IllegalArgumentException e) {
            throw new IdConversionException("Unable to convert ID value", e);
        }
    }

    public byte[] convertHexStringToBinary(String hexString) throws IllegalArgumentException {
        int length = hexString.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("The provided hex String must be an even length, but was of length " + length + ": " + hexString);
        }
        byte[] binary = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            char highBitsChar = hexString.charAt(i);
            char lowBitsChar = hexString.charAt(i + 1);
            int highBits = this.hexCharToInt(highBitsChar, hexString) << 4;
            int lowBits = this.hexCharToInt(lowBitsChar, hexString);
            binary[i / 2] = (byte)(highBits + lowBits);
        }
        return binary;
    }

    private int hexCharToInt(char ch, String orig) throws IllegalArgumentException {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("The provided hex string contains non-hex character '" + ch + "': " + orig);
    }

    public String convertBinaryToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int highBitsInt = b >> 4 & 0xF;
            int lowBitsInt = b & 0xF;
            builder.append(HEX_CHARS[highBitsInt]);
            builder.append(HEX_CHARS[lowBitsInt]);
        }
        return builder.toString();
    }
}

