/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.io.IOException;
import java.net.URI;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.util.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderFactory.class);
    private static final FactoryFinder<ProviderFactory> PROVIDER_FACTORY_FINDER = new FactoryFinder<ProviderFactory>(ProviderFactory.class, "META-INF/services/" + ProviderFactory.class.getPackage().getName().replace(".", "/") + "/");

    public abstract Provider createProvider(URI var1) throws Exception;

    public abstract String getName();

    public static Provider create(URI remoteURI) throws Exception {
        Provider result = null;
        try {
            ProviderFactory factory = ProviderFactory.findProviderFactory(remoteURI);
            result = factory.createProvider(remoteURI);
        }
        catch (Exception ex) {
            LOG.error("Failed to create Provider instance for {}, due to: {}", (Object)remoteURI.getScheme(), (Object)ex);
            LOG.trace("Error: ", (Throwable)ex);
            throw ex;
        }
        return result;
    }

    public static ProviderFactory findProviderFactory(URI location) throws IOException {
        if (location == null) {
            throw new IOException("No Provider location specified.");
        }
        return ProviderFactory.findProviderFactory(location.getScheme());
    }

    public static ProviderFactory findProviderFactory(String scheme) throws IOException {
        if (scheme == null || scheme.isEmpty()) {
            throw new IOException("No Provider scheme specified.");
        }
        ProviderFactory factory = null;
        try {
            factory = PROVIDER_FACTORY_FINDER.newInstance(scheme);
        }
        catch (Throwable e) {
            throw new IOException("Provider scheme NOT recognized: [" + scheme + "]", e);
        }
        return factory;
    }
}

